;(() => {
  document.addEventListener("DOMContentLoaded", () => {
    // Center Text plugin
    var centerTextPlugin = {
      id: "ogpCenterText",
      afterDraw: (chart, args, opts) => {
        var meta = chart.getDatasetMeta(0)
        if (!meta || !meta.data || !meta.data.length) {
          return
        }
        var x = meta.data[0].x
        var y = meta.data[0].y
        var ctx = chart.ctx
        ctx.save()
        ctx.textAlign = "center"
        ctx.textBaseline = "middle"
        ctx.font = "700 20px system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Arial,sans-serif"
        ctx.fillStyle = "#111827"
        ctx.fillText(String(opts.total || 0), x, y - 2)
        ctx.font = "500 12px system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Arial,sans-serif"
        ctx.fillStyle = "#6b7280"
        ctx.fillText("Total Tracked", x, y + 16)
        ctx.restore()
      },
    }
    function allZero(arr) {
      return arr.every((n) => Number(n) === 0)
    }
    function setFrom(key) {
      var S = window.OGP_ANALYTICS_DATA[key] || { completed: 0, cancelled: 0, auto_cleanup: 0, pending: 0, total: 0 }
      return {
        values: [+S.completed || 0, +S.cancelled || 0, +S.auto_cleanup || 0, +S.pending || 0],
        total: +S.total || 0,
      }
    }
    var labels = ["Completed", "Cancelled", "Auto Cleanup", "Pending"]

    function renderOne(canvas) {
      var key = canvas.getAttribute("data-ogp-dataset") // last24|last7|last30|all
      var wrap = canvas.closest("[data-ogp-block]")
      var empty = wrap ? wrap.querySelector(".ogp-no-data") : null
      var set = setFrom(key)
      var dataArr = set.values
      if (allZero(dataArr)) {
        canvas.style.display = "none"
        if (empty) {
          empty.style.display = "block"
        }
        return
      } else {
        canvas.style.display = "block"
        if (empty) {
          empty.style.display = "none"
        }
      }
      new Chart(canvas.getContext("2d"), {
        type: "doughnut",
        data: {
          labels: labels,
          datasets: [
            {
              data: dataArr,
              borderWidth: 0,
              hoverOffset: 6,
              cutout: "68%",
              backgroundColor: ["#16a34a", "#dc2626", "#6b7280", "#f59e0b"],
            },
          ],
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: { position: "bottom", labels: { boxWidth: 12 } },
            tooltip: {
              callbacks: {
                label: (ctx) => {
                  var v = Number(ctx.raw || 0)
                  var sum = dataArr.reduce((a, b) => a + Number(b || 0), 0) || 1
                  var pct = ((v * 100) / sum).toFixed(1)
                  return (ctx.label || "") + ": " + v + " — " + pct + "%"
                },
              },
            },
            ogpCenterText: { total: set.total },
          },
        },
        plugins: [centerTextPlugin],
      })
    }

    document.querySelectorAll("canvas[data-ogp-dataset]").forEach(renderOne)
  })
})()
