<?php
/**
 * Meta Boxes for Testimonials Custom Fields
 */

class TM_Meta_Boxes {
    
    public function __construct() {
        add_action('add_meta_boxes', array($this, 'add_meta_boxes'));
        add_action('save_post', array($this, 'save_meta_boxes'));
    }
    
    public function add_meta_boxes() {
        add_meta_box(
            'tm_testimonial_details',
            __('Testimonial Details', 'testimonials-manager'),
            array($this, 'render_meta_box'),
            'testimonial',
            'normal',
            'high'
        );
    }
    
    public function render_meta_box($post) {
        // Add nonce for security
        wp_nonce_field('tm_save_meta_box', 'tm_meta_box_nonce');
        
        // Get current values
        $client_name = get_post_meta($post->ID, '_tm_client_name', true);
        $company = get_post_meta($post->ID, '_tm_company', true);
        $rating = get_post_meta($post->ID, '_tm_rating', true);
        
        ?>
        <div class="tm-meta-box">
            <p>
                <label for="tm_client_name"><strong><?php _e('Client Name:', 'testimonials-manager'); ?></strong></label><br>
                <input type="text" id="tm_client_name" name="tm_client_name" value="<?php echo esc_attr($client_name); ?>" class="widefat" />
            </p>
            
            <p>
                <label for="tm_company"><strong><?php _e('Company:', 'testimonials-manager'); ?></strong></label><br>
                <input type="text" id="tm_company" name="tm_company" value="<?php echo esc_attr($company); ?>" class="widefat" />
            </p>
            
            <p>
                <label for="tm_rating"><strong><?php _e('Rating:', 'testimonials-manager'); ?></strong></label><br>
                <select id="tm_rating" name="tm_rating" class="widefat">
                    <option value=""><?php _e('Select Rating', 'testimonials-manager'); ?></option>
                    <?php for ($i = 1; $i <= 5; $i++) : ?>
                        <option value="<?php echo $i; ?>" <?php selected($rating, $i); ?>>
                            <?php echo str_repeat('⭐', $i) . ' (' . $i . ' ' . __('stars', 'testimonials-manager') . ')'; ?>
                        </option>
                    <?php endfor; ?>
                </select>
            </p>
        </div>
        <?php
    }
    
    public function save_meta_boxes($post_id) {
        // Check nonce
        if (!isset($_POST['tm_meta_box_nonce']) || !wp_verify_nonce($_POST['tm_meta_box_nonce'], 'tm_save_meta_box')) {
            return;
        }
        
        // Check autosave
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        
        // Check permissions
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        
        // Save client name
        if (isset($_POST['tm_client_name'])) {
            update_post_meta($post_id, '_tm_client_name', sanitize_text_field($_POST['tm_client_name']));
        }
        
        // Save company
        if (isset($_POST['tm_company'])) {
            update_post_meta($post_id, '_tm_company', sanitize_text_field($_POST['tm_company']));
        }
        
        // Save rating
        if (isset($_POST['tm_rating'])) {
            $rating = intval($_POST['tm_rating']);
            if ($rating >= 1 && $rating <= 5) {
                update_post_meta($post_id, '_tm_rating', $rating);
            }
        }
    }
}
