<?php
/**
 * Register Custom Post Type for Testimonials
 */

class TM_Post_Type {
    
    public function __construct() {
        add_action('init', array($this, 'register_post_type'));
        add_filter('manage_testimonial_posts_columns', array($this, 'set_custom_columns'));
        add_action('manage_testimonial_posts_custom_column', array($this, 'custom_column_content'), 10, 2);
    }
    
    public function register_post_type() {
        $labels = array(
            'name'                  => _x('Testimonials', 'Post Type General Name', 'testimonials-manager'),
            'singular_name'         => _x('Testimonial', 'Post Type Singular Name', 'testimonials-manager'),
            'menu_name'             => __('Testimonials', 'testimonials-manager'),
            'name_admin_bar'        => __('Testimonial', 'testimonials-manager'),
            'archives'              => __('Testimonial Archives', 'testimonials-manager'),
            'attributes'            => __('Testimonial Attributes', 'testimonials-manager'),
            'parent_item_colon'     => __('Parent Testimonial:', 'testimonials-manager'),
            'all_items'             => __('All Testimonials', 'testimonials-manager'),
            'add_new_item'          => __('Add New Testimonial', 'testimonials-manager'),
            'add_new'               => __('Add New', 'testimonials-manager'),
            'new_item'              => __('New Testimonial', 'testimonials-manager'),
            'edit_item'             => __('Edit Testimonial', 'testimonials-manager'),
            'update_item'           => __('Update Testimonial', 'testimonials-manager'),
            'view_item'             => __('View Testimonial', 'testimonials-manager'),
            'view_items'            => __('View Testimonials', 'testimonials-manager'),
            'search_items'          => __('Search Testimonial', 'testimonials-manager'),
            'not_found'             => __('Not found', 'testimonials-manager'),
            'not_found_in_trash'    => __('Not found in Trash', 'testimonials-manager'),
        );
        
        $args = array(
            'label'                 => __('Testimonial', 'testimonials-manager'),
            'description'           => __('Client Testimonials', 'testimonials-manager'),
            'labels'                => $labels,
            'supports'              => array('title', 'editor', 'thumbnail'),
            'hierarchical'          => false,
            'public'                => true,
            'show_ui'               => true,
            'show_in_menu'          => true,
            'menu_position'         => 20,
            'menu_icon'             => 'dashicons-testimonial',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'has_archive'           => true,
            'exclude_from_search'   => false,
            'publicly_queryable'    => true,
            'capability_type'       => 'post',
            'show_in_rest'          => true,
        );
        
        register_post_type('testimonial', $args);
    }
    
    public function set_custom_columns($columns) {
        $new_columns = array();
        $new_columns['cb'] = $columns['cb'];
        $new_columns['title'] = $columns['title'];
        $new_columns['client_name'] = __('Client Name', 'testimonials-manager');
        $new_columns['company'] = __('Company', 'testimonials-manager');
        $new_columns['rating'] = __('Rating', 'testimonials-manager');
        $new_columns['date'] = $columns['date'];
        
        return $new_columns;
    }
    
    public function custom_column_content($column, $post_id) {
        switch ($column) {
            case 'client_name':
                $client_name = get_post_meta($post_id, '_tm_client_name', true);
                echo esc_html($client_name ? $client_name : '—');
                break;
            case 'company':
                $company = get_post_meta($post_id, '_tm_company', true);
                echo esc_html($company ? $company : '—');
                break;
            case 'rating':
                $rating = get_post_meta($post_id, '_tm_rating', true);
                if ($rating) {
                    echo str_repeat('⭐', intval($rating));
                } else {
                    echo '—';
                }
                break;
        }
    }
}
