<?php
/**
 * Admin Settings Page
 */

class TM_Settings {
    
    public function __construct() {
        add_action('admin_menu', array($this, 'add_settings_page'));
        add_action('admin_init', array($this, 'register_settings'));
    }
    
    public function add_settings_page() {
        add_submenu_page(
            'edit.php?post_type=testimonial',
            __('Settings', 'testimonials-manager'),
            __('Settings', 'testimonials-manager'),
            'manage_options',
            'testimonials-settings',
            array($this, 'ogp_ic_render_settings_page')
        );
    }
    
    public function register_settings() {
        register_setting('tm_settings_group', 'tm_testimonials_count');
        register_setting('tm_settings_group', 'tm_layout');
        register_setting('tm_settings_group', 'tm_show_rating');
        register_setting('tm_settings_group', 'tm_show_company');
        
        add_settings_section(
            'tm_display_settings',
            __('Display Settings', 'testimonials-manager'),
            array($this, 'display_settings_callback'),
            'testimonials-settings'
        );
        
        add_settings_field(
            'tm_testimonials_count',
            __('Number of Testimonials', 'testimonials-manager'),
            array($this, 'testimonials_count_callback'),
            'testimonials-settings',
            'tm_display_settings'
        );
        
        add_settings_field(
            'tm_layout',
            __('Layout Style', 'testimonials-manager'),
            array($this, 'layout_callback'),
            'testimonials-settings',
            'tm_display_settings'
        );
        
        add_settings_field(
            'tm_show_rating',
            __('Show Rating', 'testimonials-manager'),
            array($this, 'show_rating_callback'),
            'testimonials-settings',
            'tm_display_settings'
        );
        
        add_settings_field(
            'tm_show_company',
            __('Show Company', 'testimonials-manager'),
            array($this, 'show_company_callback'),
            'testimonials-settings',
            'tm_display_settings'
        );
    }
    
    public function ogp_ic_render_settings_page() {
        ?>
        <div class="wrap">
            <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
            
            <div class="tm-settings-info">
                <h2><?php _e('How to Use', 'testimonials-manager'); ?></h2>
                <p><?php _e('Use the following shortcode to display testimonials on any page or post:', 'testimonials-manager'); ?></p>
                <code>[testimonials]</code>
                
                <h3><?php _e('Shortcode Parameters:', 'testimonials-manager'); ?></h3>
                <ul>
                    <li><code>count</code> - <?php _e('Number of testimonials to display (default: 3)', 'testimonials-manager'); ?></li>
                    <li><code>layout</code> - <?php _e('Layout style: "grid" or "slider" (default: grid)', 'testimonials-manager'); ?></li>
                    <li><code>show_rating</code> - <?php _e('Show rating: "yes" or "no" (default: yes)', 'testimonials-manager'); ?></li>
                    <li><code>show_company</code> - <?php _e('Show company: "yes" or "no" (default: yes)', 'testimonials-manager'); ?></li>
                </ul>
                
                <h3><?php _e('Example:', 'testimonials-manager'); ?></h3>
                <code>[testimonials count="5" layout="slider" show_rating="yes"]</code>
            </div>
            
            <form method="post" action="options.php">
                <?php
                settings_fields('tm_settings_group');
                do_settings_sections('testimonials-settings');
                submit_button();
                ?>
            </form>
        </div>
        <?php
    }
    
    public function display_settings_callback() {
        echo '<p>' . __('Configure default display settings for testimonials.', 'testimonials-manager') . '</p>';
    }
    
    public function testimonials_count_callback() {
        $value = get_option('tm_testimonials_count', 3);
        echo '<input type="number" name="tm_testimonials_count" value="' . esc_attr($value) . '" min="1" max="50" />';
    }
    
    public function layout_callback() {
        $value = get_option('tm_layout', 'grid');
        ?>
        <select name="tm_layout">
            <option value="grid" <?php selected($value, 'grid'); ?>><?php _e('Grid', 'testimonials-manager'); ?></option>
            <option value="slider" <?php selected($value, 'slider'); ?>><?php _e('Slider', 'testimonials-manager'); ?></option>
        </select>
        <?php
    }
    
    public function show_rating_callback() {
        $value = get_option('tm_show_rating', 'yes');
        ?>
        <label>
            <input type="radio" name="tm_show_rating" value="yes" <?php checked($value, 'yes'); ?> />
            <?php _e('Yes', 'testimonials-manager'); ?>
        </label>
        <label>
            <input type="radio" name="tm_show_rating" value="no" <?php checked($value, 'no'); ?> />
            <?php _e('No', 'testimonials-manager'); ?>
        </label>
        <?php
    }
    
    public function show_company_callback() {
        $value = get_option('tm_show_company', 'yes');
        ?>
        <label>
            <input type="radio" name="tm_show_company" value="yes" <?php checked($value, 'yes'); ?> />
            <?php _e('Yes', 'testimonials-manager'); ?>
        </label>
        <label>
            <input type="radio" name="tm_show_company" value="no" <?php checked($value, 'no'); ?> />
            <?php _e('No', 'testimonials-manager'); ?>
        </label>
        <?php
    }
}
