<?php
/**
 * Shortcode for Displaying Testimonials
 */

class TM_Shortcode {
    
    public function __construct() {
        add_shortcode('testimonials', array($this, 'render_shortcode'));
    }
    
    public function render_shortcode($atts) {
        // Parse attributes
        $atts = shortcode_atts(array(
            'count' => get_option('tm_testimonials_count', 3),
            'layout' => get_option('tm_layout', 'grid'),
            'show_rating' => get_option('tm_show_rating', 'yes'),
            'show_company' => get_option('tm_show_company', 'yes'),
        ), $atts, 'testimonials');
        
        // Query testimonials
        $args = array(
            'post_type' => 'testimonial',
            'posts_per_page' => intval($atts['count']),
            'orderby' => 'date',
            'order' => 'DESC',
        );
        
        $testimonials = new WP_Query($args);
        
        if (!$testimonials->have_posts()) {
            return '<p>' . __('No testimonials found.', 'testimonials-manager') . '</p>';
        }
        
        // Start output buffering
        ob_start();
        
        $layout_class = $atts['layout'] === 'slider' ? 'tm-slider' : 'tm-grid';
        
        ?>
        <div class="tm-testimonials-wrapper <?php echo esc_attr($layout_class); ?>">
            <?php while ($testimonials->have_posts()) : $testimonials->the_post(); ?>
                <?php
                $client_name = get_post_meta(get_the_ID(), '_tm_client_name', true);
                $company = get_post_meta(get_the_ID(), '_tm_company', true);
                $rating = get_post_meta(get_the_ID(), '_tm_rating', true);
                ?>
                
                <div class="tm-testimonial-item">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="tm-testimonial-image">
                            <?php the_post_thumbnail('thumbnail', array('class' => 'tm-client-photo')); ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="tm-testimonial-content">
                        <div class="tm-testimonial-text">
                            <?php the_content(); ?>
                        </div>
                        
                        <?php if ($atts['show_rating'] === 'yes' && $rating) : ?>
                            <div class="tm-testimonial-rating">
                                <?php echo str_repeat('⭐', intval($rating)); ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="tm-testimonial-meta">
                            <?php if ($client_name) : ?>
                                <div class="tm-client-name"><?php echo esc_html($client_name); ?></div>
                            <?php endif; ?>
                            
                            <?php if ($atts['show_company'] === 'yes' && $company) : ?>
                                <div class="tm-company"><?php echo esc_html($company); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
            <?php endwhile; ?>
        </div>
        <?php
        
        wp_reset_postdata();
        
        return ob_get_clean();
    }
}
