<?php
if (!defined('ABSPATH')) exit;

// The IC pages are now only accessible through OGP's main menu structure

function ogp_ic_license_page_callback() {
    global $ogp_ic_license_handler;
    if ($ogp_ic_license_handler) {
        $ogp_ic_license_handler->license_page();
    }
}

// Callback functions for the pages
require_once plugin_dir_path(__FILE__) . 'ogp_ic_analytics.php';
require_once plugin_dir_path(__FILE__) . 'ogp_ic_setting.php';

// Admin page content
function ogp_ic_render_abandoned_admin_page() {
    $nonce = wp_create_nonce("ogp_ic_abandon_note_nonce");
    $search_term = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';
    $paged = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
    $date_filter = isset($_GET['date_filter']) ? sanitize_text_field($_GET['date_filter']) : '';
    $items_per_page = isset($_GET['items_per_page']) ? intval($_GET['items_per_page']) : 10;

    echo '<div class="wrap">
    <h1 class="ogp-title">Incomplete Checkouts</h1>
            <hr class="align-center">
            <style>.ogp-title{font-size:24px;color:#333;font-weight:700;margin:0 0 6px;}</style>
        <form method="get" style="margin-bottom: 20px; display: flex; align-items: center; gap: 20px;">
            <input type="hidden" name="page" value="ogp-incomplete-checkout">

            <div>
                <label for="search_term" style="font-weight: bold; margin-right: 5px;">Search:</label>
                <input type="text" id="search_term" name="s" value="' . esc_attr($search_term) . '" placeholder="Search by name or phone" style="padding: 5px; width: 300px;" />
            </div>

            <div>
                <label for="date_filter" style="font-weight: bold; margin-right: 5px;">Filter by Date:</label>
                <input type="date" id="date_filter" name="date_filter" value="' . esc_attr($date_filter) . '" style="padding: 5px;" />
            </div>

            <div>
                <label for="items_per_page" style="font-weight: bold; margin-right: 5px;">Items Per Page:</label>
                <select id="items_per_page" name="items_per_page" style="padding: 5px;">
                    <option value="10" ' . selected($items_per_page, 10, false) . '>10</option>
                    <option value="20" ' . selected($items_per_page, 20, false) . '>20</option>
                    <option value="50" ' . selected($items_per_page, 50, false) . '>50</option>
                    <option value="100" ' . selected($items_per_page, 100, false) . '>100</option>
                </select>
            </div>

            <div>
                <button type="submit" class="button button-primary">Filter</button>
            </div>
        </form>

        <div class="tablenav top">
            <div class="alignleft actions bulkactions">
                <label for="bulk-action-selector-top" class="screen-reader-text">Select bulk action</label>
                <select name="action" id="bulk-action-selector-top">
                    <option value="-1">Bulk Actions</option>
                    <option value="delete">Delete</option>
                    <option value="export">Export Selected</option>
                </select>
                <button id="doaction" class="button action">Apply</button>
            </div>
            
            <div class="alignright">
                <form method="post" action="' . admin_url('admin-post.php') . '" style="margin-bottom: 20px;">
                    <input type="hidden" name="action" value="export_abandoned_checkouts">
                    <input type="submit" class="button button-secondary" value="Export All as CSV">
                </form>
            </div>
            <div class="clear"></div>
        </div>

        <div id="abandoned-table-wrap">';

        // Add custom CSS for pagination, hover effects, and bulk actions
        echo '<style>
        .tablenav-pages {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .tablenav-pages a, .tablenav-pages span {
            display: inline-block;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #007cba;
            border-radius: 4px;
            background-color: #007cba;
            color: #fff;
            text-decoration: none;
            font-size: 14px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }
        .tablenav-pages a:hover {
            background-color: #005a9c;
            color: #fff;
        }
        .tablenav-pages .current {
            background-color: rgb(209, 236, 255);
            color: rgb(41, 133, 187);
            font-weight: bold;
            cursor: default;
        }

        /* Added row separators and updated hover button styles */
        .widefat tbody tr {
            border-bottom: 1px solid #e1e1e1;
        }
.widefat thead tr {
    background-color: #3582c4;
    color:#ffffff;
    font-weight: bold;
}

.widefat thead th,
.widefat thead th a,
.widefat thead th a:visited {
    color: #ffffff !important;
    font-weight: bold;
}
/* Incomplete Checkout তালিকার 2–8 নম্বর কলাম বোল্ড */
.widefat tbody tr td:nth-child(-n+8):not(:first-child) {
    font-weight: 700 !important;
}

        .widefat th:first-child,
        .widefat td:first-child {
            width: 40px;
            text-align: center;
            padding: 8px;
        }

        #select-all-checkouts,
        .lead-checkbox {
            margin: 0;
            vertical-align: middle;
        }

        .status-toggle { display: none; }
        tr:hover .status-toggle { display: inline-block; }

        .wrap form { display: flex; flex-wrap: wrap; align-items: center; gap: 20px; }
        label { font-weight: bold; margin-right: 5px; }
        input[type="text"], input[type="date"], select {
            padding: 5px; font-size: 14px; border: 1px solid #ccc; border-radius: 4px;
        }
        .button-primary {
            background-color: #007cba; color: #fff; border: none; border-radius: 4px; padding: 8px 12px; font-size: 14px; cursor: pointer;
        }
        .button-primary:hover { background-color: #005a9c; }
        .button-secondary {
            background-color: #f3f3f3; color: #333; border: 1px solid #ccc; border-radius: 4px; padding: 8px 12px; font-size: 14px; cursor: pointer;
        }
        .button-secondary:hover { background-color: #e2e2e2; }

        select { padding: 5px 10px; font-size: 14px; border: 1px solid #ccc; border-radius: 4px; width: auto; min-width: 150px; text-align: left; }

        .bulkactions { margin-bottom: 10px; }
        #bulk-action-selector-top { margin-right: 5px; padding: 5px; border-radius: 4px; border: 1px solid #ccc; }

        .button-container .button-small {
            margin-right: 5px; padding: 4px 8px; font-size: 12px; cursor: pointer; background-color: #28a745; color: #fff; border: none; border-radius: 3px; min-width: 50px; height: 24px;
        }
        .button-container .button-small:hover { background-color: #218838; color: white; }
        .button-container .delete-button { background-color: #dc3545; color: white; }
        .button-container .delete-button:hover { background-color: #c82333; }

        .button-save-note { margin-top: 5px; padding: 5px 10px; font-size: 12px; cursor: pointer; background-color: #007cba; color: #fff; border: none; border-radius: 3px; }
        .button-save-note:hover { background-color: #005a9c; color: white; }
        .text-container { margin-bottom: 5px; }
        .button-container { display: none; margin-top: 5px; }
        tr:hover .button-container { display: block; }

        .copy-button, .call-button {
            margin-right: 5px; padding: 4px 8px; font-size: 12px; cursor: pointer; background-color: #28a745; color: #fff; border: none; border-radius: 3px; min-width: 50px; height: 24px;
        }
        .copy-button:hover, .call-button:hover { background-color: #218838; }
    </style>';

    // Render the abandoned leads table
    ogp_ic_render_abandoned_table($search_term, $paged, $items_per_page, $date_filter);

    echo '</div></div>';
    
    // Copy/Call + Bulk actions JS
    echo '<script>
    function ogp_ic_copyToClipboard(text, button) {
        navigator.clipboard.writeText(text).then(function () {
            button.textContent = "Copied";
            setTimeout(function () { button.textContent = "Copy"; }, 2000);
        }).catch(function (err) { console.error("Could not copy text: ", err); });
    }
    function ogp_ic_callPhone(phone) { window.location.href = "tel:" + phone; }
</script>';

    echo '<script>
    jQuery(document).ready(function($) {
        $("#select-all-checkouts").on("change", function() {
            $(".lead-checkbox").prop("checked", $(this).prop("checked"));
        });
        $("#doaction").on("click", function(e) {
            e.preventDefault();
            const selectedAction = $("#bulk-action-selector-top").val();
            if (selectedAction === "-1") { alert("Please select an action"); return; }
            const selectedLeads = $(".lead-checkbox:checked").map(function(){ return $(this).val(); }).get();
            if (selectedLeads.length === 0) { alert("Please select at least one checkout"); return; }
            if (selectedAction === "delete") {
                if (confirm(`Are you sure you want to delete ${selectedLeads.length} selected checkouts?`)) {
                    ogp_ic_bulkDeleteLeads(selectedLeads);
                }
            } else if (selectedAction === "export") {
                ogp_ic_bulkExportLeads(selectedLeads);
            }
        });
    });

    const ogp_ic_abandon_note_nonce = "' . $nonce . '";

    function convertToOrder(id) {
        let saveButton = document.querySelector("#row-" + id + " .button-small");
        saveButton.disabled = true; saveButton.textContent = "Converting...";
        fetch(ajaxurl, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: new URLSearchParams({ action: "ogp_ic_convert_abandoned_to_order", lead_id: id, nonce: ogp_ic_abandon_note_nonce })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                document.getElementById("row-" + id).remove();
                const notice = document.createElement("div");
                notice.className = "notice notice-success is-dismissible";
                notice.innerHTML = "<p>Successfully moved to Orders (#" + data.data.order_id + ")!</p>";
                document.querySelector(".wrap").insertBefore(notice, document.querySelector(".wrap").firstChild);
                setTimeout(() => { notice.remove(); }, 5000);
            } else {
                const errorMessage = data.data?.reason || "Unknown error occurred";
                console.error("Conversion failed:", errorMessage);
                alert("Failed to convert order: " + errorMessage);
            }
        })
        .catch(error => {
            console.error("Network error:", error);
            alert("Network error occurred while converting the order. Please try again.");
        })
        .finally(() => { saveButton.disabled = false; saveButton.textContent = "Save"; });
    }

    function ogp_ic_deleteLead(id) {
        if (!confirm("Are you sure you want to delete this lead?")) return;
        let deleteButton = document.querySelector("#row-" + id + " .delete-button");
        deleteButton.disabled = true; deleteButton.textContent = "Deleting...";
        fetch(ajaxurl, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: new URLSearchParams({ action: "ogp_ic_delete_abandoned_lead", lead_id: id, nonce: ogp_ic_abandon_note_nonce })
        })
        .then(res => res.json())
        .then(data => { if (data.success) { document.getElementById("row-" + id).remove(); } else { alert(data.data?.reason || "Failed to delete lead."); } })
        .finally(() => { deleteButton.disabled = false; deleteButton.textContent = "Delete"; });
    }

    function ogp_ic_saveNote(id) {
        let note = document.getElementById("note-" + id).value;
        let saveButton = document.querySelector("#row-" + id + " .button-save-note");
        let noteBox = document.getElementById("note-" + id);
        let successMessage = document.getElementById("success-message-" + id);
        if (!successMessage) {
            successMessage = document.createElement("div");
            successMessage.id = "success-message-" + id;
            successMessage.style.marginTop = "5px";
            successMessage.style.color = "green";
            successMessage.style.fontSize = "12px";
            noteBox.parentNode.appendChild(successMessage);
        }
        saveButton.disabled = true; saveButton.textContent = "Saving...";
        fetch(ajaxurl, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: new URLSearchParams({ action: "ogp_ic_update_abandoned_note", lead_id: id, note: note, nonce: ogp_ic_abandon_note_nonce })
        })
        .then((res) => res.json())
        .then((data) => {
            if (data.success) { successMessage.textContent = "Note saved ✅"; successMessage.style.color = "green"; }
            else { successMessage.textContent = "Failed to save ❌"; successMessage.style.color = "red"; console.error(data.data?.reason || "Unknown error"); }
        })
        .finally(() => {
            saveButton.disabled = false; saveButton.textContent = "Update";
            setTimeout(() => { successMessage.textContent = ""; }, 1500);
        });
    }
   
    function ogp_ic_bulkDeleteLeads(leadIds) {
        const $button = jQuery("#doaction");
        $button.prop("disabled", true).text("Deleting...");
        jQuery.ajax({
            url: ajaxurl, type: "POST",
            data: { action: "ogp_ic_bulk_delete_abandoned_leads", lead_ids: leadIds, nonce: ogp_ic_abandon_note_nonce },
            success: function(response) {
                if (response.success) {
                    leadIds.forEach(id => { jQuery(`#row-${id}`).remove(); });
                    alert(`Successfully deleted ${response.data.deleted} checkouts`);
                } else { alert("Error: " + (response.data?.reason || "Unknown error")); }
            },
            error: function() { alert("Server error occurred"); },
            complete: function() {
                $button.prop("disabled", false).text("Apply");
                jQuery("#select-all-checkouts").prop("checked", false);
            }
        });
    }

    function ogp_ic_bulkExportLeads(leadIds) {
        const form = document.createElement("form");
        form.method = "POST"; form.action = ajaxurl;
        const actionInput = document.createElement("input");
        actionInput.type = "hidden"; actionInput.name = "action"; actionInput.value = "ogp_ic_export_selected_abandoned_checkouts"; form.appendChild(actionInput);
        const nonceInput = document.createElement("input");
        nonceInput.type = "hidden"; nonceInput.name = "nonce"; nonceInput.value = ogp_ic_abandon_note_nonce; form.appendChild(nonceInput);
        leadIds.forEach(id => {
            const leadInput = document.createElement("input");
            leadInput.type = "hidden"; leadInput.name = "lead_ids[]"; leadInput.value = id; form.appendChild(leadInput);
        });
        document.body.appendChild(form); form.submit(); document.body.removeChild(form);
        jQuery("#select-all-checkouts").prop("checked", false);
    }
    </script>';
}

// ===== TABLE RENDERER (with Completed/Placed exclusion) =====
function ogp_ic_render_abandoned_table($search = '', $paged = 1, $posts_per_page = 10, $date_filter = '') {
    global $wpdb;

    $table_name = $wpdb->prefix . 'ogp_incomplete_checkout';

    // WHERE building with placeholders
    $where  = array("1=1");
    $params_where = array();

    // Only Pending
    $where[] = "status = 'Pending'";

    // Woo statuses considered as placed orders (for phone fallback)
    $wc_statuses = array('wc-pending','wc-processing','wc-on-hold','wc-completed');

    // Tables
    $posts_table = $wpdb->posts;
    $pm_table    = $wpdb->postmeta;

    // [ATTEMPT-ID] HPOS meta table (if present)
    $hpos_meta   = $wpdb->prefix . 'wc_orders_meta';
    $hpos_orders = $wpdb->prefix . 'wc_orders';
    $hpos_addr   = $wpdb->prefix . 'wc_order_addresses';
    $hpos_meta_exists = $wpdb->get_var("SHOW TABLES LIKE '{$hpos_meta}'");
    $hpos_orders_exists = $wpdb->get_var("SHOW TABLES LIKE '{$hpos_orders}'");

    // Normalize phone (last 10 digits) for comparison (phone-fallback only)
    $norm_ic   = "RIGHT(REPLACE(REPLACE(REPLACE({$table_name}.phone,'+',''),'-',''),' ',''),10)";
    $norm_meta = "RIGHT(REPLACE(REPLACE(REPLACE(pm.meta_value,'+',''),'-',''),' ',''),10)";

    // ============================================================
    // [ATTEMPT-ID] PRIMARY EXCLUSION: exclude if this attempt is linked to any Woo order
    // Legacy posts/postmeta
    $where[] =
      "(
         {$table_name}.attempt_id = '' OR
         NOT EXISTS (
           SELECT 1
           FROM {$pm_table} pm2
           INNER JOIN {$posts_table} p2 ON p2.ID = pm2.post_id AND p2.post_type = 'shop_order'
           WHERE pm2.meta_key = '_ogp_ic_attempt_id'
             AND pm2.meta_value = {$table_name}.attempt_id
         )
       )";

    // HPOS meta (if available)
    if ( $hpos_meta_exists ) {
        $where[] =
          "(
             {$table_name}.attempt_id = '' OR
             NOT EXISTS (
               SELECT 1
               FROM {$hpos_meta} m2
               WHERE m2.meta_key = '_ogp_ic_attempt_id'
                 AND m2.meta_value = {$table_name}.attempt_id
             )
           )";
    }
    // ============================================================

    // Legacy posts/postmeta NOT EXISTS by phone (fallback for rows without attempt_id)
    $where[] =
      "(
         {$table_name}.attempt_id <> '' OR
         NOT EXISTS (
           SELECT 1
           FROM {$posts_table} p
           INNER JOIN {$pm_table} pm
             ON pm.post_id = p.ID AND pm.meta_key = '_billing_phone'
           WHERE {$norm_meta} = {$norm_ic}
             AND p.post_type   = 'shop_order'
             AND p.post_status IN (" . implode(',', array_fill(0, count($wc_statuses), '%s')) . ")
             AND p.post_date  >= {$table_name}.date
         )
       )";
    foreach ($wc_statuses as $s) { $params_where[] = $s; }

    // HPOS support (wc_orders) by phone (fallback)
    if ( $hpos_orders_exists ) {
        $norm_addr = "RIGHT(REPLACE(REPLACE(REPLACE(a.phone,'+',''),'-',''),' ',''),10)";
        $where[] =
          "(
             {$table_name}.attempt_id <> '' OR
             NOT EXISTS (
               SELECT 1
               FROM {$hpos_orders} o
               INNER JOIN {$hpos_addr} a
                 ON a.order_id = o.id AND a.address_type = 'billing'
               WHERE {$norm_addr} = {$norm_ic}
                 AND o.status IN (" . implode(',', array_fill(0, count($wc_statuses), '%s')) . ")
             )
           )";
        foreach ($wc_statuses as $s) { $params_where[] = $s; }
    }

    // Search
    if ($search) {
        $where[] = "(name LIKE %s OR phone LIKE %s)";
        $params_where[] = '%' . $wpdb->esc_like($search) . '%';
        $params_where[] = '%' . $wpdb->esc_like($search) . '%';
    }

    // Date filter
    if ($date_filter) {
        $where[] = "DATE(date) = %s";
        $params_where[] = $date_filter;
    }

    $where_clause = implode(' AND ', $where);

    // Count
    $count_sql = "SELECT COUNT(*) FROM {$table_name} WHERE {$where_clause}";
    $total_count = $wpdb->get_var( $wpdb->prepare($count_sql, $params_where) );

    // Page data
    $offset = ($paged - 1) * $posts_per_page;
    $select_sql = "SELECT * FROM {$table_name} WHERE {$where_clause} ORDER BY created_at DESC LIMIT %d OFFSET %d";
    $params_select = array_merge($params_where, array( $posts_per_page, $offset ));
    $leads = $wpdb->get_results( $wpdb->prepare($select_sql, $params_select) );

    $start_item = $offset + 1;
    $end_item   = min($offset + $posts_per_page, $total_count);

    echo '<table class="widefat striped">
    <thead>
        <tr>
            <th><input type="checkbox" id="select-all-checkouts"></th>
            <th>Date</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Address</th>
            <th>IP Address</th>
            <th>Subtotal</th>
            <th>Products</th>
            <th>Status</th>
            <th>Note</th>
        </tr>
    </thead>
    <tbody>';
         
    if (empty($leads)) {
            echo '<tr><td colspan="10">No incomplete checkouts found.</td></tr>';
        } else {
            foreach ($leads as $lead) {
                $id         = $lead->id;
                $name       = (trim((string)$lead->name) !== '')
                                ? esc_html($lead->name)
                                : '<span style="color:#cc0000;font-weight:600;">No Name Provided</span>';
                $phone      = esc_html($lead->phone);
                $addr       = (trim((string)$lead->address) !== '')
                                ? esc_html($lead->address)
                                : '<span style="color:#cc0000;font-weight:600;">No Address Provided</span>';
                $ip_address = esc_html($lead->ip_address);
                $subtotal   = esc_html(number_format((float)$lead->subtotal, 2));
                $products   = esc_html($lead->products);
                $date       = esc_html($lead->date);
                $note       = esc_textarea($lead->note);
                $status     = esc_html($lead->status);
        
            echo "<tr id='row-$id'>
    <td><input type='checkbox' class='lead-checkbox' value='$id'></td>
    <td>$date</td>
    <td>
        <div class='text-container'>$name</div>
        <div class='button-container'>
            <button class='copy-button' onclick='ogp_ic_copyToClipboard(\"$name\", this)' aria-label='Copy name'>Copy</button>
        </div>
    </td>
    <td>
        <div class='text-container'>$phone</div>
        <div class='button-container'>
            <button class='call-button' onclick='ogp_ic_callPhone(\"$phone\")' aria-label='Call phone'>Call</button>
            <button class='copy-button' onclick='ogp_ic_copyToClipboard(\"$phone\", this)' aria-label='Copy phone'>Copy</button>
        </div>
    </td>
    <td>
        <div class='text-container'>$addr</div>
        <div class='button-container'>
            <button class='copy-button' onclick='ogp_ic_copyToClipboard(\"$addr\", this)' aria-label='Copy address'>Copy</button>
        </div>
    </td>
    <td>
        <div class='text-container'>$ip_address</div>
        <div class='button-container'>
            <button class='copy-button' onclick='ogp_ic_copyToClipboard(\"$ip_address\", this)' aria-label='Copy IP address'>Copy</button>
        </div>
    </td>
    <td>$subtotal</td>
    <td>$products</td>
    <td>
        <div class='text-container'><span id='status-$id'>$status</span></div>
        <div class='button-container'>
            <button class='button button-small' onclick='convertToOrder($id)' aria-label='Save order'>Save</button>
            <button class='button button-small delete-button' onclick='ogp_ic_deleteLead($id)' aria-label='Delete draft'>Delete</button>
        </div>
    </td>
    <td>
        <textarea id='note-$id' rows='2' style='width:100%;'>$note</textarea>
        <button class='button button-small button-save-note' onclick='ogp_ic_saveNote($id)'>Update</button>
    </td>
</tr>";
        }
    }

    echo '</tbody></table>';

    $total_pages = ceil($total_count / $posts_per_page);
    if ($total_pages > 1) {
        echo '<div class="tablenav"><div class="tablenav-pages">';
        echo paginate_links([
            'base' => add_query_arg('paged', '%#%'),
            'format' => '',
            'current' => $paged,
            'total' => $total_pages,
        ]);
        echo '</div></div>';
    }

    echo '<div class="table-summary">
        Showing ' . $start_item . ' to ' . $end_item . ' of ' . $total_count . ' incomplete checkouts
    </div>';
}

// ===== Export CSV (with same exclusion) =====
add_action('admin_post_export_abandoned_checkouts', function () {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ogp_incomplete_checkout';

    $posts_table = $wpdb->posts;
    $pm_table    = $wpdb->postmeta;
    $wc_statuses = array('wc-pending','wc-processing','wc-on-hold','wc-completed');

    // [ATTEMPT-ID] HPOS meta table
    $hpos_meta   = $wpdb->prefix . 'wc_orders_meta';
    $hpos_orders = $wpdb->prefix . 'wc_orders';
    $hpos_addr   = $wpdb->prefix . 'wc_order_addresses';
    $hpos_meta_exists   = $wpdb->get_var("SHOW TABLES LIKE '{$hpos_meta}'");
    $hpos_orders_exists = $wpdb->get_var("SHOW TABLES LIKE '{$hpos_orders}'");

    // Normalize (phone fallback)
    $norm_ic   = "RIGHT(REPLACE(REPLACE(REPLACE(ic.phone,'+',''),'-',''),' ',''),10)";
    $norm_meta = "RIGHT(REPLACE(REPLACE(REPLACE(pm.meta_value,'+',''),'-',''),' ',''),10)";

    $conditions = array();
    $params     = array();

    // ============================================================
    // [ATTEMPT-ID] PRIMARY EXCLUSION by attempt_id (Legacy)
    $conditions[] = "
      (
        ic.attempt_id = '' OR
        NOT EXISTS (
          SELECT 1
          FROM {$pm_table} pm2
          INNER JOIN {$posts_table} p2 ON p2.ID = pm2.post_id AND p2.post_type = 'shop_order'
          WHERE pm2.meta_key = '_ogp_ic_attempt_id'
            AND pm2.meta_value = ic.attempt_id
        )
      )";

    // [ATTEMPT-ID] PRIMARY EXCLUSION by attempt_id (HPOS meta)
    if ($hpos_meta_exists) {
        $conditions[] = "
          (
            ic.attempt_id = '' OR
            NOT EXISTS (
              SELECT 1
              FROM {$hpos_meta} m2
              WHERE m2.meta_key = '_ogp_ic_attempt_id'
                AND m2.meta_value = ic.attempt_id
            )
          )";
    }
    // ============================================================

    // posts/postmeta NOT EXISTS by phone (fallback)
    $conditions[] = "
      (
        ic.attempt_id <> '' OR
        NOT EXISTS (
          SELECT 1
          FROM {$posts_table} p
          INNER JOIN {$pm_table} pm
            ON pm.post_id = p.ID AND pm.meta_key = '_billing_phone'
          WHERE {$norm_meta} = {$norm_ic}
            AND p.post_type   = 'shop_order'
            AND p.post_status IN (" . implode(',', array_fill(0, count($wc_statuses), '%s')) . ")
            AND p.post_date  >= ic.date
        )
      )";
    foreach ($wc_statuses as $s) { $params[] = $s; }

    // HPOS NOT EXISTS by phone (fallback)
    if ( $hpos_orders_exists ) {
        $norm_addr = "RIGHT(REPLACE(REPLACE(REPLACE(a.phone,'+',''),'-',''),' ',''),10)";
        $conditions[] = "
          (
            ic.attempt_id <> '' OR
            NOT EXISTS (
              SELECT 1
              FROM {$hpos_orders} o
              INNER JOIN {$hpos_addr} a
                ON a.order_id = o.id AND a.address_type = 'billing'
              WHERE {$norm_addr} = {$norm_ic}
                AND o.status IN (" . implode(',', array_fill(0, count($wc_statuses), '%s')) . ")
            )
          )";
        foreach ($wc_statuses as $s) { $params[] = $s; }
    }

    $sql = "
      SELECT *
      FROM {$table_name} ic
      WHERE ic.status = 'Pending'
        AND " . implode(" AND ", $conditions) . "
      ORDER BY ic.created_at DESC
    ";

    $leads = $wpdb->get_results( $wpdb->prepare($sql, $params) );

    // CSV Output
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="abandoned-checkouts.csv"');

    $output = fopen('php://output', 'w');
    fputcsv($output, ['Date','Name','Phone','Address','IP Address','Subtotal','Products','Status','Note']);

    foreach ($leads as $lead) {
        fputcsv($output, [
            $lead->date,
            $lead->name,
            $lead->phone,
            $lead->address,
            $lead->ip_address,
            $lead->subtotal,
            $lead->products,
            $lead->status,
            $lead->note
        ]);
    }
    fclose($output);
    exit;
});
