<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

function ogp_ic_render_settings_page() {
    if (isset($_POST['save_settings'])) {
        $cleanup_interval = intval($_POST['cleanup_interval']);
        if ($cleanup_interval < 1 || $cleanup_interval > 30) {
            echo '<div class="error"><p>Cleanup interval must be between 1 and 30 days.</p></div>';
        } else {
            update_option('ogp_ic_abandoned_cleanup_interval', $cleanup_interval);
            ogp_ic_update_cleanup_schedule(); // Update the scheduled event
        }
    }

    $cleanup_interval = get_option('ogp_ic_abandoned_cleanup_interval', 30);

    $next_scheduled = wp_next_scheduled('ogp_ic_cleanup_old_abandoned_leads_event');
    $last_run = get_option('ogp_ic_last_cleanup_time', 0);
    
    $next_ts = $next_scheduled ? ogp_ic_convert_to_bangladesh_time($next_scheduled) : 'Not scheduled';
    $prev_ts = $last_run > 0 ? ogp_ic_convert_to_bangladesh_time($last_run) : 'Never';

    ?>
    <style>
        /* Completely redesigned CSS for single green box layout */
        .ic-auto-cleanup-wrapper {
            max-width: 800px;
            margin: 20px 0;
        }
        .ic-auto-cleanup-box {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            border-radius: 12px;
            padding: 24px;
            position: relative;
        }
        .ic-cleanup-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .ic-cleanup-title {
            font-size: 16px;
            font-weight: 600;
            color: #065f46;
            margin: 0;
        }
        .ic-pills {
            display: flex;
            gap: 10px;
        }
        .ic-pill {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 6px;
            background: #f8f9fa;
            font-size: 12px;
            color: #495057;
            border: 1px solid #e9ecef;
            white-space: nowrap;
        }
        .ic-pill strong {
            color: #212529;
            font-weight: 600;
        }
        .ic-interval-row {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }
        .ic-interval-label {
            font-size: 14px;
            font-weight: 500;
            color: #065f46;
            min-width: 60px;
        }
        .ic-interval-input {
            width: 80px;
            height: 36px;
            border: 1px solid #bbf7d0;
            border-radius: 6px;
            padding: 0 12px;
            font-size: 14px;
            color: #065f46;
            background: #fff;
        }
        .ic-interval-input:focus {
            outline: none;
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        .ic-interval-suffix {
            font-size: 14px;
            color: #059669;
        }
        .ic-dynamic-text {
            font-size: 13px;
            color: #059669;
            margin: 0;
        }
        .ic-btn-save {
            background: #10b981;
            color: #fff;
            border: none;
            border-radius: 6px;
            height: 38px;
            padding: 0 24px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s;
            margin-top: 16px;
        }
        .ic-btn-save:hover {
            background: #059669;
        }
        
        /* Hide the parent page's blue Save Changes button */
        .wrap form p.submit {
            display: none !important;
        }
        
        @media (max-width: 768px) {
            .ic-cleanup-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 12px;
            }
            .ic-pills {
                flex-direction: column;
                gap: 8px;
                width: 100%;
            }
            .ic-pill {
                width: 100%;
            }
            .ic-interval-row {
                flex-wrap: wrap;
            }
        }
    </style>
    <?php
    
    echo '<div class="ic-auto-cleanup-wrapper">';
    
    echo '<div class="ic-auto-cleanup-box">';
    
    // Header with title and pills
    echo '<div class="ic-cleanup-header">';
    echo '<h3 class="ic-cleanup-title">🧹 Auto Cleanup</h3>';
    echo '<div class="ic-pills">';
    echo '<span class="ic-pill"><strong>Next:</strong> ' . esc_html($next_ts) . '</span>';
    echo '<span class="ic-pill"><strong>Prev:</strong> ' . esc_html($prev_ts) . '</span>';
    echo '</div>';
    echo '</div>';
    
    // Interval input row
    echo '<div class="ic-interval-row">';
    echo '<label class="ic-interval-label" for="cleanup_interval">Interval</label>';
    echo '<input type="number" id="cleanup_interval" name="cleanup_interval" class="ic-interval-input" value="' . esc_attr($cleanup_interval) . '" min="1" max="30" />';
    echo '<span class="ic-interval-suffix">days</span>';
    echo '</div>';
    
    // Dynamic text that updates based on input
    echo '<p class="ic-dynamic-text" id="ic-dynamic-message">Incomplete Checkouts history will be removed after <strong>' . esc_html($cleanup_interval) . '</strong> days.</p>';
    
    echo '</div>'; // End auto-cleanup-box
    
    echo '<button type="submit" name="save_settings" class="ic-btn-save">Save Changes</button>';
    
    echo '</div>'; // End wrapper
    
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        $('#cleanup_interval').on('input', function() {
            var days = $(this).val();
            if (days >= 1 && days <= 30) {
                $('#ic-dynamic-message').html('Incomplete Checkouts history will be removed after <strong>' + days + '</strong> days.');
            }
        });
    });
    </script>
    <?php
}
