// --- Injected helper to ensure Block ID exists before delete ---
function ogpEnsureBlockId($row, done){
  var id = $row.attr('data-block-id') || $row.find('.ogp-delete-block').data('block-id');
  if (id && String(id).match(/^\d+$/)) { done(id); return; }
  var ip = $row.data('ip') || '';
  var phone = $row.data('phone') || '';
  var nonce = jQuery('#ogp_blocking_nonce').val() || jQuery('#ogp_blocking_search_nonce').val() || '';
  jQuery.post(ajaxurl, {
    action: 'ogp_lookup_block_id',
    ogp_blocking_nonce: nonce,
    ip_value: ip,
    number_value: phone
  }, function(resp){
    if (resp && resp.success && resp.data && resp.data.id){
      var found = resp.data.id;
      $row.attr('data-block-id', found);
      $row.find('.ogp-delete-block, .ogp-save-comment').attr('data-block-id', found);
      done(found);
    } else { done(null); }
  }, 'json');
}

/* global jQuery, ajaxurl */
var jQuery = window.jQuery
var ajaxurl = window.ajaxurl

jQuery(document).ready(($) => {
  var ogp_phone_validation = $("#ogp_phone_validation").val()
  $("#ogp_phone_validation_toggle").minitoggle()
  if (ogp_phone_validation == 1) {
    $("#ogp_phone_validation_toggle .minitoggle").addClass("active")
    $("#ogp_phone_validation_toggle .toggle-handle").css("transform", "translate3d(36px, 0px, 0px)")
  }
  $("#ogp_phone_validation_toggle").on("toggle", (e) => {
    if (e.isActive) $("#ogp_phone_validation").val(1)
    else $("#ogp_phone_validation").val(0)
  })

  var ogp_order_interval_validation = $("#ogp_order_interval_validation").val()
  $("#ogp_order_interval_toggle").minitoggle()
  if (ogp_order_interval_validation == 1) {
    $("#ogp_order_interval_toggle .minitoggle").addClass("active")
    $("#ogp_order_interval_toggle .toggle-handle").css("transform", "translate3d(36px, 0px, 0px)")
  }
  $("#ogp_order_interval_toggle").on("toggle", (e) => {
    if (e.isActive) $("#ogp_order_interval_validation").val(1)
    else $("#ogp_order_interval_validation").val(0)
  })

  $(".ogp_get_order_ip_toggle").minitoggle()
  $(".ogp_get_order_number_toggle").minitoggle()

  $(document).ready(() => {
    $(".ogp-input-box.ogp_get_order_ip").each(function () {
      if ($(this).val() === "1") {
        $(this).closest("td").find(".ogp_get_order_ip_toggle .minitoggle").addClass("active")
        $(this).closest("td").find(".toggle-handle").css("transform", "translate3d(22px, 0px, 0px)")
      }
    })
  })

  $(document).on("toggle", ".ogp_get_order_ip_toggle", function (e) {
    const inputField = $(this).closest("td").find(".ogp-input-box.ogp_get_order_ip")
    if (e.isActive) {
      inputField.val("1").trigger("change")
    } else {
      inputField.val("0").trigger("change")
    }
  })

  $(document).on("change", ".ogp-input-box.ogp_get_order_ip", function () {
    const blockType = $(this).attr("data-block-type")
    const ipValue = $(this).attr("data-order-ip")
    const ogp_blocking_nonce_value = $("#ogp_blocking_nonce").val()
    const ogp_current_username = $("#ogp_current_username").val()
    if ($(this).val() === "1") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_block_ip_number",
          block_type: blockType,
          ip_value: ipValue,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
          ogp_blocked_via: ogp_current_username,
        },
        success: (response) => {
          if (response.success) {
            alert("IP blocked successfully!")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    } else if ($(this).val() === "0") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_unblock_ip_number",
          block_type: blockType,
          ip_value: ipValue,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
        },
        success: (response) => {
          if (response.success) {
            alert("IP unblocked successfully!")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    }
  })

  $(document).ready(() => {
    $(".ogp-input-box.ogp_get_order_number").each(function () {
      if ($(this).val() === "1") {
        $(this).closest("td").find(".ogp_get_order_number_toggle .minitoggle").addClass("active")
        $(this).closest("td").find(".toggle-handle").css("transform", "translate3d(22px, 0px, 0px)")
      }
    })
  })

  $(document).on("toggle", ".ogp_get_order_number_toggle", function (e) {
    const inputField = $(this).closest("td").find(".ogp-input-box.ogp_get_order_number")
    if (e.isActive) {
      inputField.val("1").trigger("change")
    } else {
      inputField.val("0").trigger("change")
    }
  })

  $(document).on("change", ".ogp-input-box.ogp_get_order_number", function () {
    const blockType = $(this).attr("data-block-type")
    const numberValue = $(this).attr("data-order-number")
    const ogp_blocking_nonce_value = $("#ogp_blocking_nonce").val()
    const ogp_current_username = $("#ogp_current_username").val()
    if ($(this).val() === "1") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_block_ip_number",
          block_type: blockType,
          number_value: numberValue,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
          ogp_blocked_via: ogp_current_username,
        },
        success: (response) => {
          if (response.success) {
            alert("Number blocked successfully!")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    } else if ($(this).val() === "0") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_unblock_ip_number",
          block_type: blockType,
          number_value: numberValue,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
        },
        success: (response) => {
          if (response.success) {
            alert("Number unblocked successfully!")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    }
  })

var modal = document.getElementById("ogp-order-report-modal")
var modal_order_result = document.getElementById("ogp-order-report-modal")
  var closeBtn = document.querySelectorAll(".ogp-close")

  closeBtn.forEach((button) => {
    button.addEventListener("click", () => {
      modal.style.display = "none"
      modal_order_result.style.display = "none"
    })
  })

  window.addEventListener("click", (event) => {
    if (event.target === modal) {
      modal.style.display = "none"
    }
    if (event.target === modal_order_result) {
      modal_order_result.style.display = "none"
    }
  })

  $(document).on("ajaxSuccess", () => {
    $(
      "#ogp_blocking_results tbody .ogp_get_order_number_toggle:not(.initialized), #ogp_order_results tbody .ogp_get_order_number_toggle:not(.initialized)",
    ).each(function () {
      $(this).minitoggle()
      $(this).addClass("initialized")
    })

    $(
      "#ogp_blocking_results tbody .ogp-input-box.ogp_get_order_number, #ogp_order_results tbody .ogp-input-box.ogp_get_order_number",
    ).each(function () {
      if ($(this).val() === "1") {
        $(this).closest("td").find(".ogp_get_order_number_toggle .minitoggle").addClass("active")
        $(this).closest("td").find(".toggle-handle").css("transform", "translate3d(22px, 0px, 0px)")
      }
    })
    $(
      "#ogp_blocking_results tbody .ogp_get_order_ip_toggle:not(.initialized), #ogp_order_results tbody .ogp_get_order_ip_toggle:not(.initialized)",
    ).each(function () {
      $(this).minitoggle()
      $(this).addClass("initialized")
    })

    $(
      "#ogp_blocking_results tbody .ogp-input-box.ogp_get_order_ip, #ogp_order_results tbody .ogp-input-box.ogp_get_order_ip",
    ).each(function () {
      if ($(this).val() === "1") {
        $(this).closest("td").find(".ogp_get_order_ip_toggle .minitoggle").addClass("active")
        $(this).closest("td").find(".toggle-handle").css("transform", "translate3d(22px, 0px, 0px)")
      }
    })
  })

  //Order Search
  $("#ogp_order_search_btn").on("click", (event) => {
    event.preventDefault()

    var ogp_order_number = $("#ogp_order_number").val()
    var ogp_order_nonce_value = $("#ogp_order_search_nonce").val()
    if (ogp_order_number.trim() === "") {
      alert("Please enter a number to search.")
      return
    }

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "ogp_search_order",
        ogp_order_number: ogp_order_number,
        ogp_order_search_nonce: ogp_order_nonce_value,
      },
      beforeSend: () => {
        $("#ogp_order_search_btn").prop("disabled", true).text("Searching...")
      },
      success: (response) => {
        $("#ogp_order_search_btn").prop("disabled", false).text("Search")

        if (response.success) {
          modal_order_result.style.display = "flex"
          $("#ogp_order_results tbody").html("")
          var row =
            "<tr>" +
            "<td>" +
            response.data.order_id +
            "</td>" +
            "<td>" +
            response.data.order_date +
            "</td>" +
            "<td>" +
            response.data.order_ip +
            "</td>" +
            "<td>" +
            response.data.billing_phone +
            "</td>" +
            "<td>" +
            '<div class="ogp_get_order_ip_toggle"></div>' +
            '<input class="ogp-input-box ogp_get_order_ip" data-block-type="IP" data-order-ip="' +
            response.data.order_ip +
            '" type="hidden" value="' +
            response.data.blocked_ip +
            '">' +
            "</td>" +
            "<td>" +
            '<div class="ogp_get_order_number_toggle"></div>' +
            '<input class="ogp-input-box ogp_get_order_number" data-block-type="Number" data-order-number="' +
            response.data.billing_phone +
            '" type="hidden" value="' +
            response.data.blocked_number +
            '">' +
            "</td>" +
            "</tr>"

          $("#ogp_order_results tbody").append(row)
        } else {
          modal_order_result.style.display = "flex"
          $("#ogp_order_results tbody").html('<tr><td colspan="6">' + response.data.message + "</td></tr>")
        }
      },
      error: () => {
        $("#ogp_order_search_btn").prop("disabled", false).text("Search")
        alert("AJAX request failed. Please try again.")
      },
    })
  })
  //Order Search End

  $("#ogp_blocking_number_btn").on("click", (event) => {
    event.preventDefault()

    var ogp_blocking_number = $("#ogp_blocking_number").val()
    var ogp_blocking_nonce_value = $("#ogp_blocking_search_nonce").val()
    if (ogp_blocking_number.trim() === "") {
      alert("Please enter a number to search.")
      return
    }

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "ogp_search_block_number",
        ogp_blocking_number: ogp_blocking_number,
        ogp_blocking_search_nonce: ogp_blocking_nonce_value,
      },
      beforeSend: () => {
        $("#ogp_blocking_number_btn").prop("disabled", true).text("Searching...")
      },
      success: (response) => {
        $("#ogp_blocking_number_btn").prop("disabled", false).text("Search")

        if (response.success) {
          modal.style.display = "flex"
          $("#ogp_blocking_results tbody").html("")
          const row = response.data
          const html = `<tr>
                        <td>${row.block_type}</td>
                        <td>${row.details}</td>
                        <td>${row.blocked_time}</td>
                        <td>
                            <div class="ogp_get_order_number_toggle"></div>
                            <input class="ogp-input-box ogp_get_order_number" 
                                   data-block-type="${row.block_type}" 
                                   data-order-number="${row.details}" 
                                   type="hidden" value="1">
                        </td>
                    </tr>`

          $("#ogp_blocking_results tbody").append(html)
        } else {
          modal.style.display = "flex"
          $("#ogp_blocking_results tbody").html('<tr><td colspan="4">No blocked records found.</td></tr>')
        }
      },
      error: () => {
        $("#ogp_blocking_number_btn").prop("disabled", false).text("Search")
        alert("AJAX request failed. Please try again.")
      },
    })
  })

  $("#ogp_blocking_ip_btn").on("click", (event) => {
    event.preventDefault()

    var ogp_blocking_ip = $("#ogp_blocking_ip").val()
    var ogp_blocking_nonce_value = $("#ogp_blocking_search_nonce").val()
    if (ogp_blocking_ip.trim() === "") {
      alert("Please enter a ip to search.")
      return
    }

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "ogp_search_block_ip",
        ogp_blocking_ip: ogp_blocking_ip,
        ogp_blocking_search_nonce: ogp_blocking_nonce_value,
      },
      beforeSend: () => {
        $("#ogp_blocking_ip_btn").prop("disabled", true).text("Searching...")
      },
      success: (response) => {
        $("#ogp_blocking_ip_btn").prop("disabled", false).text("Search")

        if (response.success) {
          modal.style.display = "flex"
          $("#ogp_blocking_results tbody").html("")
          const row = response.data
          const html = `<tr>
                        <td>${row.block_type}</td>
                        <td>${row.details}</td>
                        <td>${row.blocked_time}</td>
                        <td>
                            <div class="ogp_get_order_ip_toggle"></div>
                            <input class="ogp-input-box ogp_get_order_ip" 
                                   data-block-type="${row.block_type}" 
                                   data-order-ip="${row.details}" 
                                   type="hidden" value="1">
                        </td>
                    </tr>`

          $("#ogp_blocking_results tbody").append(html)
        } else {
          modal.style.display = "flex"
          $("#ogp_blocking_results tbody").html('<tr><td colspan="4">No blocked records found.</td></tr>')
        }
      },
      error: () => {
        $("#ogp_blocking_ip_btn").prop("disabled", false).text("Search")
        alert("AJAX request failed. Please try again.")
      },
    })
  })

  $(document).on("click", ".ogp-get-order-report", function () {
    const orderID = $(this).data("order-id")
    const customerID = $(this).data("customer-id")
    const nonce = $(this).data("nonce")

    if (!orderID || !nonce) {
      console.error("Missing order ID or nonce")
      return
    }

    window.ogpCurrentOrderData = { orderID: orderID, customerID: customerID }

    fetchAndShowDetailedModal(orderID, customerID, nonce)
  })

  function fetchAndShowDetailedModal(orderID, customerID, nonce) {
    // Create detailed modal immediately
    createDetailedOGPModal(customerID, orderID)

    showLoadingState()

    // Fetch data right away
    $.ajax({
      url: ajaxurl,
      type: "POST",
      dataType: "json",
      data: {
        action: "ogp_fetch_column_order_report",
        ogp_column_order_report_id: orderID,
        ogp_column_order_report_nonce: nonce,
      },
      success: (response) => {
        hideLoadingState()

        if (response.success && response.data && typeof response.data.total !== "undefined") {
          const data = response.data

          // ✅ Upstream 429 হলে তবেই লিমিট UI
          if (data && data.error_code === 429) {
            showErrorCard(
              "Upstream API error (429)",
              data.error_message || "You've hit the report limit. Please try again later.",
            )
            return
          }

          // Populate data
          $("#ogp-number").text(data.number || "")
          $("#ogp-total").text(data.total || 0)
          $("#ogp-success").text(data.success || 0)
          $("#ogp-failed").text(data.failed || 0)
          $("#ogp-ratio").text((data.ratio || 0) + "%")

          // Determine zone and apply styling
          const ratio = data.ratio || 0
          const zone = getZone(ratio)

          $("#ogp-ratio").css("color", zone.color)
          $("#ogp-status").html(`<span style="color: ${zone.color};">${zone.emoji}</span> ${zone.label}`)
         $("#ogp-comment-en").html(`💬 "${zone.commentEn}"`)
         $("#ogp-comment-bn").html(`📝 ${zone.commentBn}`)


          $("#ogp-report-data").show()
          $("#ogp-error-card").hide()
        } else {
          let errorMessage = "Failed to load report data."
          if (response.data && response.data.error_message) {
            errorMessage = response.data.error_message
          } else if (response.data && typeof response.data === "string") {
            errorMessage = response.data
          }
          showErrorCard("Error", errorMessage)
        }
      },
      error: (xhr) => {
        hideLoadingState()
        handleAjaxError(xhr)
      },
    })
  }

  function showLoadingState() {
    $("#ogp-report-data").hide()
    $("#ogp-error-card").hide()
    $("#ogp-loading-state").show()
  }

  function hideLoadingState() {
    $("#ogp-loading-state").hide()
  }

  function handleAjaxError(xhr) {
    let errorTitle = "Error"
    let errorMessage = "Couldn't load report. Please try again in a moment."

    if (xhr.status === 429) {
      errorTitle = "Upstream API error (429)"
      errorMessage = "You've hit the report limit. Please try again later."

      // Parse Retry-After header if present
      const retryAfter = xhr.getResponseHeader("Retry-After")
      if (retryAfter) {
        const minutes = Math.ceil(retryAfter / 60)
        errorMessage += ` Retry after: ${minutes} minutes.`
      }
    } else if (xhr.status === 401 || xhr.status === 403) {
      errorTitle = "Not allowed"
      errorMessage = "You don't have permission to view this report."
    } else if (xhr.status === 404) {
      errorTitle = "No data found"
      errorMessage = "No report data found for this number."
    }

    showErrorCard(errorTitle, errorMessage)
  }

  function showErrorCard(title, message) {
    $("#ogp-report-data").hide()
    $("#ogp-loading-state").hide()

    $("#ogp-error-title").text(title)
    $("#ogp-error-message").text(message)
    $("#ogp-error-card").show()
  }

  function retryFetch() {
    if (window.ogpCurrentOrderData) {
      const { orderID, customerID } = window.ogpCurrentOrderData
      const nonce = $(".ogp-get-order-report").first().data("nonce")
      fetchAndShowDetailedModal(orderID, customerID, nonce)
    }
  }

  function createDetailedOGPModal(customerID, orderID) {
    // Remove existing modal if present
    $("#ogp-order-report-modal").remove()

    let profileUrl = "#"
    let linkAttributes = 'style="pointer-events: none; cursor: default; opacity: 0.6;"'

    if (customerID && customerID > 0) {
      profileUrl = `user-edit.php?user_id=${customerID}`
      linkAttributes = ""
    } else if (orderID) {
      profileUrl = `post.php?post=${orderID}&action=edit`
      linkAttributes = ""
    }

    // Create modal HTML
    const modalHTML = `
      <div id="ogp-order-report-modal" role="dialog" aria-modal="true" style="
        position: fixed;
        inset: 0;
        background: rgba(0,0,0,0.55);
        z-index: 100000;
        display: grid;
        place-items: center;
        padding: 24px;
      ">
        <div class="ogp-modal-panel" style="
          width: 100%;
          max-width: 440px;
          background: #fff;
          border: 1px solid #e5e7eb;
          border-radius: 16px;
          box-shadow: 0 20px 40px rgba(0,0,0,0.18);
          position: relative;
          margin: 0;
          transform: none;
          padding: 24px;
        ">
          <button class="ogp-close" style="
            position: absolute;
            top: 10px;
            right: 10px;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #666;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
          " aria-label="Close modal">&times;</button>
          
          <div style="text-align: center;">
            <a href="${profileUrl}" ${linkAttributes} class="ogp-check-report-btn" id="ogp-customer-link" style="
              background: #2271B1;
              color: white;
              border: none;
              padding: 12px 20px;
              border-radius: 6px;
              font-size: 14px;
              font-weight: 600;
              cursor: pointer;
              margin-bottom: 24px;
              text-decoration: none;
              display: inline-block;
              transition: background-color 0.2s;
            " onclick="event.stopPropagation()" onmouseover="this.style.background='#135E96'" onmouseout="this.style.background='#2271B1'">Show Full Report</a>
          </div>

          <!-- Add loading state -->
          <div id="ogp-loading-state" style="text-align: center; padding: 40px 0;">
            <div style="
              width: 32px;
              height: 32px;
              border: 3px solid #f3f4f6;
              border-top: 3px solid #2271B1;
              border-radius: 50%;
              animation: spin 1s linear infinite;
              margin: 0 auto 16px;
            "></div>
            <div style="color: #6b7280; font-size: 14px;">Loading report data...</div>
          </div>

          <!-- Add error card -->
          <div id="ogp-error-card" style="
            margin-top: 12px;
            border-radius: 8px;
            border: 1px solid #fecaca;
            background: #fef2f2;
            padding: 16px;
            font-size: 14px;
            color: #991b1b;
            display: none;
          ">
            <div id="ogp-error-title" style="font-weight: 600; margin-bottom: 4px;"></div>
            <div id="ogp-error-message" style="margin-bottom: 12px;"></div>
            <button onclick="retryFetch()" style="
              padding: 6px 12px;
              border-radius: 4px;
              background: #2271B1;
              color: white;
              border: none;
              font-size: 12px;
              cursor: pointer;
            ">Try Again</button>
          </div>

          <div id="ogp-report-data" style="display: none;">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px; margin-bottom: 24px;">
              <div>
                <div style="color: #6b7280; font-size: 14px; margin-bottom: 4px;">Number:</div>
                <div id="ogp-number" style="color: #2563eb; font-weight: 600;"></div>
              </div>
              <div>
                <div style="color: #6b7280; font-size: 14px; margin-bottom: 4px;">Total:</div>
                <div id="ogp-total" style="font-weight: 600;"></div>
              </div>
              <div>
                <div style="color: #6b7280; font-size: 14px; margin-bottom: 4px;">Success:</div>
                <div id="ogp-success" style="font-weight: 600;"></div>
              </div>
              <div>
                <div style="color: #6b7280; font-size: 14px; margin-bottom: 4px;">Failed:</div>
                <div id="ogp-failed" style="color: #dc2626; font-weight: 600;"></div>
              </div>
            </div>

            <div style="text-align: center; margin-bottom: 24px;">
              <div style="color: #6b7280; font-size: 14px; margin-bottom: 4px;">Ratio:</div>
              <div id="ogp-ratio" style="font-size: 24px; font-weight: 700;"></div>
            </div>

            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; font-size: 12px;">
              <span style="display: flex; align-items: center; gap: 4px;"><span style="width: 12px; height: 12px; background: #00A32A; border-radius: 50%; display: inline-block;"></span> 80-100%</span>
              <span style="display: flex; align-items: center; gap: 4px;"><span style="width: 12px; height: 12px; background: #DBA617; border-radius: 50%; display: inline-block;"></span> 60-80%</span>
              <span style="display: flex; align-items: center; gap: 4px;"><span style="width: 12px; height: 12px; background: #F97316; border-radius: 50%; display: inline-block;"></span> 40-60%</span>
              <span style="display: flex; align-items: center; gap: 4px;"><span style="width: 12px; height: 12px; background: #D63638; border-radius: 50%; display: inline-block;"></span> 0-40%</span>
            </div>

            <div style="background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 12px; padding: 16px;">
              <div style="font-weight: 600; margin-bottom: 8px;">Status & Comment</div>
              <div id="ogp-status" style="margin-bottom: 8px;"></div>
              <div id="ogp-comment-en" style="font-size: 14px; margin-bottom: 4px;"></div>
              <div id="ogp-comment-bn" style="font-size: 14px; color: #6b7280;"></div>
            </div>
          </div>
        </div>
      </div>

      <style>
        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
      </style>
    `

    // Append to body
    $("body").append(modalHTML)

    // Lock scroll
    document.body.style.overflow = "hidden"

    // Focus trap
    $("#ogp-order-report-modal").focus()

    // Setup event handlers for this modal instance
    setupDetailedModalHandlers()

    window.retryFetch = retryFetch
  }

  function setupDetailedModalHandlers() {
    const modal = $("#ogp-order-report-modal")

    // Close modal handlers
    modal.find(".ogp-close").on("click", closeModal)

    modal.on("click", (event) => {
      if (event.target === event.currentTarget) {
        closeModal()
      }
    })

    // ESC key handler
    $(document).on("keydown.ogpModal", (event) => {
      if (event.key === "Escape" && modal.length) {
        closeModal()
      }
    })
  }

  $(document).on("click", ".ogp-get-order-ip-block", function () {
    const button = $(this)
    const blockType = button.attr("data-block-type")
    const ipValue = button.attr("data-order-ip")
    const ogp_current_username = button.attr("data-current-user")
    const ogp_blocking_nonce_value = button.attr("data-nonce")
    const actionType = button.text().trim().toLowerCase()

    console.log(ogp_current_username)

    if (actionType === "block ip") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_block_ip_number",
          block_type: blockType,
          ip_value: ipValue,
          ogp_blocked_via: ogp_current_username,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
        },
        success: (response) => {
          if (response.success) {
            alert("IP blocked successfully!")
            button.text("Unblock IP")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    } else if (actionType === "unblock ip") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_unblock_ip_number",
          block_type: blockType,
          ip_value: ipValue,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
        },
        success: (response) => {
          if (response.success) {
            alert("IP unblocked successfully!")
            button.text("Block IP")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    }
  })

  $(document).on("click", ".ogp-get-order-number-block", function () {
    const button = $(this)
    const blockType = button.attr("data-block-type")
    const numberValue = button.attr("data-order-number")
    const ogp_current_username = button.attr("data-current-user")
    const ogp_blocking_nonce_value = button.attr("data-nonce")
    const actionType = button.text().trim().toLowerCase()

    console.log(ogp_current_username)

    if (actionType === "block number") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_block_ip_number",
          block_type: blockType,
          number_value: numberValue,
          ogp_blocked_via: ogp_current_username,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
        },
        success: (response) => {
          if (response.success) {
            alert("Number blocked successfully!")
            button.text("Unblock Number")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    } else if (actionType === "unblock number") {
      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "ogp_check_and_unblock_ip_number",
          block_type: blockType,
          number_value: numberValue,
          ogp_blocking_nonce: ogp_blocking_nonce_value,
        },
        success: (response) => {
          if (response.success) {
            alert("Number unblocked successfully!")
            button.text("Block Number")
          } else {
            alert("Error: " + response.data)
          }
        },
        error: () => {
          alert("AJAX request failed.")
        },
      })
    }
  })

  var ogp_report_in_order_list = $("#ogp_report_in_order_list").val()
  $("#ogp_report_in_order_list_toggle").minitoggle()
  if (ogp_report_in_order_list == 1) {
    $("#ogp_report_in_order_list_toggle .minitoggle").addClass("active")
    $("#ogp_report_in_order_list_toggle .toggle-handle").css("transform", "translate3d(36px, 0px, 0px)")
  }
  $("#ogp_report_in_order_list_toggle").on("toggle", (e) => {
    if (e.isActive) $("#ogp_report_in_order_list").val(1)
    else $("#ogp_report_in_order_list").val(0)
  })

  var ogp_block_in_order_list = $("#ogp_block_in_order_list").val()
  $("#ogp_block_in_order_list_toggle").minitoggle()
  if (ogp_block_in_order_list == 1) {
    $("#ogp_block_in_order_list_toggle .minitoggle").addClass("active")
    $("#ogp_block_in_order_list_toggle .toggle-handle").css("transform", "translate3d(36px, 0px, 0px)")
  }
  $("#ogp_block_in_order_list_toggle").on("toggle", (e) => {
    if (e.isActive) $("#ogp_block_in_order_list").val(1)
    else $("#ogp_block_in_order_list").val(0)
  })

  $("#woocommerce_orders_pagination").on("change", function () {
  var selectedPage = $(this).val();
  var currentUrl = new URL(window.location.href);
  currentUrl.searchParams.set("paged", selectedPage);
  try { localStorage.setItem('ogp_active_tab', '#ogp-tab-allorder'); } catch(e){}
  window.location.href = currentUrl.toString();
});

$("#blocked_pagination").on("change", function () {
  var selectedPage = $(this).val();
  var currentUrl = new URL(window.location.href);
  currentUrl.searchParams.set("blocked", selectedPage);
  try { localStorage.setItem('ogp_active_tab', '#ogp-tab-blocklist'); } catch(e){}
  window.location.href = currentUrl.toString();
});

  function closeModal() {
    $("#ogp-order-report-modal").remove()
    document.body.style.overflow = ""
    $(document).off("keydown.ogpModal")
    delete window.retryFetch
  }

  $(document).on("click", ".ogp-save-comment", function (e) {
    e.preventDefault()

    const button = $(this)
    const blockId = button.data("block-id")
    const commentInput = button.siblings(".ogp-comment-input")
    const comment = commentInput.val()
    const ogp_blocking_nonce_value = $("#ogp_blocking_nonce").val()

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "ogp_update_block_comment",
        block_id: blockId,
        comment: comment,
        ogp_blocking_nonce: ogp_blocking_nonce_value,
      },
      beforeSend: () => {
        button.prop("disabled", true).text("Saving...")
      },
      success: (response) => {
        button.prop("disabled", false).text("Save")
        if (response.success) {
          const successMsg = $(
            '<span class="ogp-success-msg" style="color: green; font-size: 12px; margin-left: 5px;">Saved!</span>',
          )
          button.after(successMsg)
          setTimeout(() => successMsg.fadeOut(), 2000)
        } else {
          alert("Error: " + response.data)
        }
      },
      error: () => {
        button.prop("disabled", false).text("Save")
        alert("AJAX request failed.")
      },
    })
  })

  $(document).on("click", ".ogp-delete-block", function (e) {
    e.preventDefault()

    if (
      !confirm(
        "Are you sure you want to unblock this entry? This will remove it from the block list and update the All Order toggles.",
      )
    ) {
      return
    }

    const button = $(this)
    const blockId = button.data("block-id")
    const unblockedIp = button.data("ip")
    const unblockedPhone = button.data("phone")
    const ogp_blocking_nonce_value = $("#ogp_blocking_nonce").val()
    const row = button.closest("tr")

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "ogp_delete_block_entry",
        block_id: blockId,
        ogp_blocking_nonce: ogp_blocking_nonce_value,
      },
      beforeSend: () => {
        button.prop("disabled", true).text("Deleting...")
      },
      success: (response) => {
        if (response.success) {
          row.fadeOut(300, function () {
            $(this).remove()
          })

          if (unblockedIp) {
            $('.ogp_get_order_ip[data-order-ip="' + unblockedIp + '"]').each(function () {
              $(this).val("0")
              const toggle = $(this).closest("td").find(".ogp_get_order_ip_toggle")
              toggle.find(".minitoggle").removeClass("active")
              toggle.find(".toggle-handle").css("transform", "translate3d(0px, 0px, 0px)")
            })
          }

          if (unblockedPhone) {
            $('.ogp_get_order_number[data-order-number="' + unblockedPhone + '"]').each(function () {
              $(this).val("0")
              const toggle = $(this).closest("td").find(".ogp_get_order_number_toggle")
              toggle.find(".minitoggle").removeClass("active")
              toggle.find(".toggle-handle").css("transform", "translate3d(0px, 0px, 0px)")
            })
          }

          alert("Entry unblocked successfully!")
        } else {
          button.prop("disabled", false).text("Delete")
          alert("Error: " + response.data)
        }
      },
      error: () => {
        button.prop("disabled", false).text("Delete")
        alert("AJAX request failed.")
      },
    })
  })
})

// Function to determine zone based on ratio
function getZone(ratio) {
  const zones = [
    {
      key: "trusted",
      min: 80,
      max: 100,
      label: "Trusted Zone",
      emoji: "🟢",
      color: "#00A32A",
      commentEn: "You can deliver with full confidence.",
      commentBn: "সম্পূর্ণ আস্থার সাথে ডেলিভারি করতে পারেন।",
    },
    {
      key: "caution",
      min: 60,
      max: 79,
      label: "Caution Zone",
      emoji: "🟡",
      color: "#DBA617",
      commentEn: "Proceed with care, some risk may exist.",
      commentBn: "সতর্কভাবে এগোন, কিছু ঝুঁকি থাকতে পারে।",
    },
    {
      key: "risk",
      min: 40,
      max: 59,
      label: "Risk Zone",
      emoji: "🟠",
      color: "#F97316",
      commentEn: "High attention required, delivery may face issues.",
      commentBn: "উচ্চ সতর্কতা প্রয়োজন, ডেলিভারি চার্জ নেওয়া প্রয়োজন হতে পারে।",
    },
    {
      key: "critical",
      min: 0,
      max: 39,
      label: "Critical Zone",
      emoji: "🔴",
      color: "#D63638",
      commentEn: "Severe risk detected, delivery not recommended.",
      commentBn: "গুরুতর ঝুঁকি শনাক্ত হয়েছে, অবশ্যই ডেলিভারি চার্জ নেওয়া প্রয়োজন।",
    },
  ];

  for (const zone of zones) {
    if (ratio >= zone.min && ratio <= zone.max) {
      return zone;
    }
  }
  return zones[zones.length - 1]; // Default to critical
}
