(function($){
  // Helper: format timestamp like PHP 'F j, Y g:i a'
  function formatDate(ts){
    try {
      var d = ts ? new Date(ts) : new Date();
      var months = ["January","February","March","April","May","June","July","August","September","October","November","December"];
      var h = d.getHours();
      var ampm = h >= 12 ? "pm" : "am";
      h = h % 12; if (h === 0) h = 12;
      var min = d.getMinutes(); if (min < 10) min = "0"+min;
      return months[d.getMonth()]+" "+d.getDate()+", "+d.getFullYear()+" "+h+":"+min+" "+ampm;
    } catch(e){ return ""; }
  }

  // Build a Block List <tr> using existing class hooks
  
      // Try to parse JSON response to extract real ID and set it on the new row
      var setRealId = function($row, payload){
        try{
          if (!payload) return;
          var obj = (typeof payload === 'string') ? JSON.parse(payload) : payload;
          if (obj && (obj.id || (obj.data && (obj.data.id || obj.data.block_id)))){
            var rid = obj.id || (obj.data && (obj.data.id || obj.data.block_id));
            if (String(rid).match(/^\d+$/)) {
              $row.attr('data-block-id', rid);
              var $btn = $row.find('.ogp-delete-block');
              $btn.prop('disabled', false).attr('data-block-id', rid).attr('title','');
            }
          }
        }catch(_){ /* ignore */ }
      };

  function buildRow(opts){
    var id = (typeof opts.id !== 'undefined') ? opts.id : null;
    var type = opts.type || "Phone";
    var details = opts.details || "";
    var blockedTime = formatDate();
    // Construct row HTML compatible with existing handlers:
    // - .ogp-comment-input + .ogp-save-comment[data-block-id]
    // - .ogp-delete-block[data-block-id]
    var $tr = $('<tr/>', {
      'data-block-id': (id && String(id).match(/^\d+$/)) ? id : '',
      'data-ip': opts.ip || '',
      'data-phone': opts.phone || ''
    });
    // No. placeholder (will be recalculated)
    $tr.append($('<td/>').text('1'));
    $tr.append($('<td/>').text(blockedTime));
    $tr.append($('<td/>').text(type));
    $tr.append($('<td/>').text(details));
    var $commentTd = $('<td/>');
    var $commentWrap = $('<div/>', {'class': 'ogp-comment-container'});
    $commentWrap.append($('<input/>', {
      'type':'text',
      'class':'ogp-comment-input',
      'placeholder':'Add comment...',
      'css': { width: '150px', marginRight: '5px' }
    }));
    $commentWrap.append($('<button/>', {
      'class':'ogp-save-comment button button-small',
      'text':'Save',
      'data-block-id': id
    }));
    $commentTd.append($commentWrap);
    var $deleteTd = $('<td/>');
    $deleteTd.append($('<button/>', {
      'class':'ogp-delete-block button button-small',
      'text':'Delete',
      'data-block-id': (id && String(id).match(/^\d+$/)) ? id : '',
      'css': { background: '#dc3545', color: '#fff' }
    }));
    $tr.append($commentTd).append($deleteTd);
    return $tr;
  }

  // Re-number the first column (No.) after insert/remove
  function renumber(){
    $('#ogp-get-all-blocking tbody tr, #ogp_blocking_results tbody tr').each(function(i){
      $(this).children('td').first().text(i+1);
    });
  }

  // De-dupe by (phone, ip) pair
  function removeDuplicates(ip, phone){
    if (!ip && !phone) return;
    $('#ogp-get-all-blocking tbody tr, #ogp_blocking_results tbody tr').each(function(){
      var dip = $(this).attr('data-ip') || '';
      var dph = $(this).attr('data-phone') || '';
      if ((ip && dip === ip) || (phone && dph === phone)) {
        $(this).remove();
      }
    });
  }

  // Insert or update row at the top
  function upsertTop(opts){
    var $tbody = $('#ogp-get-all-blocking tbody, #ogp_blocking_results tbody');
    if (!$tbody.length) return;

    removeDuplicates(opts.ip || '', opts.phone || '');
    var $row = buildRow(opts);
    $tbody.prepend($row);
    renumber();
  }

  // Listen to all WP admin-ajax successes and reflect instantly
  $(document).ajaxSuccess(function(event, xhr, settings){
    try{
      if (!settings || typeof settings.data !== 'string') return;
      var params = new URLSearchParams(settings.data);
      var action = params.get('action');
      if (action === 'ogp_check_and_block_ip_number') {
        var blockType = params.get('block_type') || '';
        var ip = params.get('ip_value') || '';
        var phone = params.get('number_value') || '';
        var typeLabel = 'Phone';
        var details = '';
        if (ip && phone) { typeLabel = 'Phone + IP'; details = phone + ' / ' + ip; }
        else if (ip) { typeLabel = 'IP'; details = ip; }
        else if (phone) { typeLabel = 'Phone'; details = phone; }

        // Update Block List immediately (visible or not)
        var $added = (function(){ upsertTop({ type: typeLabel, details: details, ip: ip, phone: phone }); return $('#ogp-get-all-blocking tbody tr:first'); })();
        setRealId($added, (xhr && (xhr.responseJSON || xhr.responseText)) || null);
      }
      else if (action === 'ogp_check_and_unblock_ip_number') {
        var ipU = params.get('ip_value') || '';
        var phoneU = params.get('number_value') || '';
        // Remove matching rows
        removeDuplicates(ipU, phoneU);
        renumber();
      }
    }catch(e){
      // Silent fail – keep UI stable
    }
  });

  // Tab switch handler: nothing special required since we insert even if hidden.
  // But ensure emojis are present (safe re-apply).
  $(function(){
    $('.nav-tab[data-target="#ogp-tab-blocklist"]').each(function(){
      var t = $(this).text().trim();
      if (t.indexOf('🛡️') === -1) $(this).text('🛡️ ' + t.replace(/^Block List$/,'Block List'));
    });
    $('.nav-tab[data-target="#ogp-tab-allorder"]').each(function(){
      var t = $(this).text().trim();
      if (t.indexOf('📦') === -1) $(this).text('📦 ' + t.replace(/^All Order$/,'All Order'));
    });
  });


  // Optional guard: prevent delete if no numeric id (should be disabled anyway)
  $(document).on('click', '.ogp-delete-block', function(e){
    var id = $(this).data('block-id');
    if (!id || !String(id).match(/^\d+$/)) {
      e.preventDefault(); e.stopImmediatePropagation();
      alert('Please wait a moment while we finish syncing this entry. Then try Delete again.');
      return false;
    }
  });

})(jQuery);


;(function($){
  // Fallback: align row buttons with a real DB id by looking it up
  function ogpLookupAndAttachId($row, cb){
    try{
      var ip = $row.data('ip') || '';
      var phone = $row.data('phone') || '';
      var nonce = $('#ogp_blocking_nonce').val() || $('#ogp_blocking_search_nonce').val() || '';
      $.post(ajaxurl, {
        action: 'ogp_lookup_block_id',
        ogp_blocking_nonce: nonce,
        ip_value: ip,
        number_value: phone
      }, function(resp){
        if (resp && resp.success && resp.data && resp.data.id){
          var id = resp.data.id;
          $row.attr('data-block-id', id);
          $row.find('.ogp-delete-block').attr('data-block-id', id);
          $row.find('.ogp-save-comment').attr('data-block-id', id);
          if (typeof cb === 'function') cb(id);
        } else {
          if (typeof cb === 'function') cb(null);
        }
      }, 'json');
    }catch(e){ if (typeof cb === 'function') cb(null); }
  }

  // Patch existing helper if present
  if (typeof window.setRealId === 'function'){
    var _oldSetRealId = window.setRealId;
    window.setRealId = function($row, resp){
      var id = null;
      try{
        if (resp && resp.success && resp.data){
          id = resp.data.id || resp.data.insert_id || resp.data.block_id || null;
        }
      }catch(e){}
      if (id){
        $row.attr('data-block-id', id);
        $row.find('.ogp-delete-block').attr('data-block-id', id);
        $row.find('.ogp-save-comment').attr('data-block-id', id);
        return;
      }
      // Fallback lookup
      ogpLookupAndAttachId($row);
    };
  }

  // Intercept Delete clicks: if no id yet, lookup and then re-trigger delete
  $(document).on('click', '.ogp-delete-block', function(e){
    var $btn = $(this);
    var id = $btn.data('block-id');
    if (id && String(id).match(/^\d+$/)) return; // proceed normally

    e.preventDefault(); e.stopImmediatePropagation();
    var $row = $btn.closest('tr');
    ogpLookupAndAttachId($row, function(foundId){
      if (foundId){
        // Trigger the original click again after id attached
        setTimeout(function(){ $btn.trigger('click'); }, 0);
      } else {
        alert('Could not sync this entry yet. Please try again.');
      }
    });
  });
})(jQuery);
