<?php
function ogp_display_logged_in_username() {
    if (is_user_logged_in()) {
        $current_user = wp_get_current_user();
        echo '<input type="hidden" id="ogp_current_username" value="' . esc_attr($current_user->user_login) . '">';
    }
}

function ogp_display_woocommerce_orders_table() {
   if (!class_exists('WooCommerce')) {
        echo '<p>WooCommerce is not active.</p>';
        return;
    }

    $page = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
    $per_page = 10;
    $offset = ($page - 1) * $per_page;

    $args = array(
        'limit'    => $per_page,
        'offset'   => $offset,
        'paginate' => true,
    );
    $orders = wc_get_orders($args);

    echo '<table id="ogp-get-all-order" class="table table-bordered" width="100%" cellspacing="0">
            <thead>
                <tr class="ogp-table-header-row">
                    <th>Order Id</th>
                    <th>Order Date</th>
                    <th>IP Address</th>
                    <th>Block IP</th>
                    <th>Phone Number</th>
                    <th>Block Number</th>
                </tr>
            </thead>
            <tbody>';

    // Loop through orders
    if (!empty($orders->orders)) {
        foreach ($orders->orders as $order) {
            $order_id = $order->get_id();
            $order_ip = $order->get_customer_ip_address();
            $billing_phone = $order->get_billing_phone();
            $order_date = $order->get_date_created()->date('M j, Y');
			$blocked_ip = ogp_block_ip_search($order_ip);
			$blocked_number = ogp_block_number_search($billing_phone);
            
            echo '<tr>
                    <td>' . esc_html($order_id) . '</td>
                    <td>' . esc_html($order_date) . '</td>
                    <td>' . esc_html($order_ip) . '</td>
                    <td>
						<div class="ogp_get_order_ip_toggle"></div>
						<input class="ogp-input-box ogp_get_order_ip" data-block-type="IP" data-order-ip="' . esc_js($order_ip) . '" type="hidden" value="'. esc_js($blocked_ip) .'">
					</td>
                    <td>' . esc_html($billing_phone) . '</td>
                    <td>
						<div class="ogp_get_order_number_toggle"></div>
						<input class="ogp-input-box ogp_get_order_number" data-block-type="Number" data-order-number="' . esc_js($billing_phone) . '" type="hidden" value="'. esc_js($blocked_number ) .'">
					</td>
                  </tr>';
        }
    } else {
        echo '<tr><td colspan="6">No orders found.</td></tr>';
    }

    echo '</tbody>
			<tfoot>
                <tr class="ogp-table-header-row">
                    <th>Order Id</th>
                    <th>Order Date</th>
                    <th>IP Address</th>
                    <th>Block IP</th>
                    <th>Phone Number</th>
                    <th>Block Number</th>
                </tr>
            </tfoot>
		</table>';

    $total_pages = ceil($orders->total / $per_page);
	if ($total_pages > 1) {
		echo '<div class="ogp-pagination" style="padding-bottom: 0.5rem;">';
		echo '<label for="woocommerce_orders_pagination" style="font-size: 1rem;">Jump to: </label>';
		echo '<select id="woocommerce_orders_pagination">';
		for ($i = 1; $i <= $total_pages; $i++) {
			$selected = ($i == $page) ? 'selected' : '';
			echo '<option value="' . esc_attr($i) . '" ' . $selected . '>' . esc_html($i) . '</option>';
		}
		echo '</select>';
		echo '</div>';
	}
}

function ogp_display_blocked_data() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ogp_block7';

    $per_page = 50;
    $page = isset($_GET['blocked']) ? intval($_GET['blocked']) : 1;
    $offset = ($page - 1) * $per_page;

    $total_records = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");

    $results = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM $table_name ORDER BY blockedTime DESC LIMIT %d OFFSET %d",
        $per_page,
        $offset
    ));

    echo '<table id="ogp-get-all-blocking" class="table table-bordered" width="100%" cellspacing="0">
            <thead>
                <tr class="ogp-table-header-row">
                    <th>No.</th>
                    <th>Blocking Time</th>
                    <th>Block Type</th>
                    <th>Details</th>
                    <th>Comment</th>
                    <th>Delete</th>
                </tr>
            </thead>
            <tbody>';

    if (!empty($results)) {
        $serial = $offset + 1;
        foreach ($results as $row) {
            $has_ip = !empty($row->ip);
            $has_phone = !empty($row->phoneNumber);
            
            if ($has_ip && $has_phone) {
                $block_type = 'Phone + IP';
                $details = $row->phoneNumber . ' / ' . $row->ip;
            } elseif ($has_ip) {
                $block_type = 'IP';
                $details = $row->ip;
            } else {
                $block_type = 'Phone';
                $details = $row->phoneNumber;
            }
            
            $blocked_time_formatted = date('F j, Y g:i a', $row->blockedTime);
            $comment = !empty($row->comment) ? esc_html($row->comment) : '';

            echo '<tr data-block-id="' . esc_attr($row->id) . '">
                    <td>' . esc_html($serial) . '</td>
                    <td>' . esc_html($blocked_time_formatted) . '</td>
                    <td>' . esc_html($block_type) . '</td>
                    <td>' . esc_html($details) . '</td>
                    <td>
                        <div class="ogp-comment-container">
                            <input type="text" class="ogp-comment-input" value="' . $comment . '" placeholder="Add comment..." style="width: 150px; margin-right: 5px;">
                            <button class="ogp-save-comment button button-small" data-block-id="' . esc_attr($row->id) . '">Save</button>
                        </div>
                    </td>
                    <td>
                        <button class="ogp-delete-block button button-small" data-block-id="' . esc_attr($row->id) . '" data-ip="' . esc_attr($row->ip) . '" data-phone="' . esc_attr($row->phoneNumber) . '" style="background: #dc3545; color: white;">Delete</button>
                    </td>
                  </tr>';

            $serial++;
        }
    } else {
        echo '<tr><td colspan="6">No blocked records found.</td></tr>';
    }

    echo '</tbody>
			<tfoot>
                <tr class="ogp-table-header-row">
                    <th>No.</th>
                    <th>Blocking Time</th>
                    <th>Block Type</th>
                    <th>Details</th>
                    <th>Comment</th>
                    <th>Delete</th>
                </tr>
            </tfoot>
		</table>';

    // Pagination links
    $total_pages = ceil($total_records / $per_page);
	if ($total_pages > 1) {
		echo '<div class="ogp-pagination" style="padding-bottom: 0.5rem;">';
		echo '<label for="blocked_pagination" style="font-size: 1rem;">Jump to: </label>';
		echo '<select id="blocked_pagination">';
		for ($i = 1; $i <= $total_pages; $i++) {
			$selected = ($i == $page) ? 'selected' : '';
			echo '<option value="' . esc_attr($i) . '" ' . $selected . '>' . esc_html($i) . '</option>';
		}
		echo '</select>';
		echo '</div>';
	}
}

function ogp_blocking_page_callback(){
?>
<!-- Added unique wrapper class to isolate OGP styles from FakeOrderShield -->
<div class="wrap ogp-block-list-wrapper" id="ogp_settings">
    <div class="ogp-container">
        <div style="display:flex;flex-direction:column;">
            <h1 class="ogp-title">Block List</h1>
            <hr class="align-center">
<style>#ogp_settings .nav-tab-wrapper{border-bottom:none !important;box-shadow:none !important;}
#ogp_settings .nav-tab, #ogp_settings .nav-tab-active{box-shadow:none !important;border-bottom:none !important;}
.ogp-title{font-size:24px;color:#333;font-weight:700;margin:0 0 6px;}</style>
        </div>

        <!-- Tabs -->
        <h2 class="nav-tab-wrapper" style="margin-top:8px;">
            <a href="#" class="nav-tab nav-tab-active" data-target="#ogp-tab-blocklist">🛡️ Block List</a>
            <a href="#" class="nav-tab" data-target="#ogp-tab-allorder">📦 All Order</a>
        </h2>

        <!-- Block List tab (DEFAULT) -->
        <div id="ogp-tab-blocklist" class="ogp-tab is-active" style="display:block;margin-top:12px;">
            <div class="ogp-settings-section" style="margin-top: 0.5rem;">
                <h2 style="font-size:1.1rem;font-weight:700;margin:0 0 10px;">Live Search</h2>
                <input type="search" id="ogp-live-search-input" class="regular-text" placeholder="Type to filter by phone or IP (e.g., 018, 103.)" style="width:100%;max-width:520px;">
            </div>
            <div class="ogp-settings-section" style="margin-top: 0.5rem;">
                <h2 style="font-size: 1.4rem; font-weight: 600; color: #000; margin: 0 0 1rem;">Block History</h2>
                <div style="overflow-x:auto">
                    <?php wp_nonce_field('ogp_blocked', 'ogp_blocked_nonce');?>
                    <?php ogp_display_blocked_data();?>
                </div>
            </div>
        </div>

        <!-- All Order tab -->
        <div id="ogp-tab-allorder" class="ogp-tab" style="display:none;margin-top:12px;">
            <div class="ogp-settings-section" style="margin-top: 0.5rem;">
                
                <?php wp_nonce_field('ogp_order_search', 'ogp_order_search_nonce');?>
                <div style="overflow-x:auto">
                    <?php ogp_display_logged_in_username();?>
                    <?php wp_nonce_field('ogp_blocking', 'ogp_blocking_nonce');?>
                    <?php ogp_display_woocommerce_orders_table();?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
  // === TAB state keep (Block List / All Order) ===
  const tabs  = document.querySelectorAll('.nav-tab-wrapper .nav-tab');
  const panes = document.querySelectorAll('.ogp-tab');

  function activate(selector){
    tabs.forEach(x=>x.classList.remove('nav-tab-active'));
    panes.forEach(p=>p.style.display='none');
    const link = document.querySelector(`.nav-tab[data-target="${selector}"]`) || tabs[0];
    const pane = document.querySelector(selector) || panes[0];
    if (link) link.classList.add('nav-tab-active');
    if (pane) pane.style.display = 'block';
    try { localStorage.setItem('ogp_active_tab', selector); } catch(e){}
  }

  tabs.forEach(t=>{
    t.addEventListener('click', function(e){
      e.preventDefault();
      activate(this.getAttribute('data-target'));
    });
  });

  // Restore last active tab after refresh/navigation
  let saved = null;
  try { saved = localStorage.getItem('ogp_active_tab'); } catch(e){}
  activate(saved || '#ogp-tab-blocklist');

  // === Live filter for Block History table ===
  const input = document.getElementById('ogp-live-search-input');
  if (input) {
    input.addEventListener('input', function(){
      const q = this.value.trim().toLowerCase().replace(/\s+/g,'');
      const rows = document.querySelectorAll('#ogp-get-all-blocking tbody tr');
      rows.forEach(function(tr){
        const detailsCell = tr.querySelector('td:nth-child(4)');
        const value = (detailsCell ? detailsCell.textContent : tr.textContent).trim().toLowerCase();
        const norm  = value.replace(/[^0-9a-z\.+]/g,''); // digits/letters/dot/plus
        tr.style.display = (q === '' || norm.startsWith(q)) ? '' : 'none';
      });
    });
  }
});
</script>
<?php	
}
?>
