<?php
// Initialize the admin columns
add_action('admin_init', 'ogp_initialize_custom_order_columns');
function ogp_initialize_custom_order_columns() {
    add_filter('manage_edit-shop_order_columns', 'ogp_order_report_custom_columns', 11);
    add_action('manage_shop_order_custom_column', 'ogp_order_report', 10, 2);
    add_action('manage_shop_order_custom_column', 'ogp_order_block', 10, 2);
    
    add_filter('woocommerce_shop_order_list_table_columns', 'ogp_order_report_custom_columns');
    add_action('woocommerce_shop_order_list_table_custom_column', 'ogp_order_report', 10, 2);
    add_action('woocommerce_shop_order_list_table_custom_column', 'ogp_order_block', 10, 2);
    
}

function ogp_order_report_custom_columns($columns) {
    $ogp_report_in_order_list = get_option('ogp_report_in_order_list',0);
    $ogp_block_in_order_list = get_option('ogp_block_in_order_list',0);
    
    if ($ogp_report_in_order_list == 1) {
        $columns['ogp_order_report'] = __('Order Insight', 'order-growth-plugin');
    }
    
    if ($ogp_block_in_order_list == 1) {
        $columns['ogp_order_block'] = __('Risk Control', 'order-growth-plugin');
    }
    return $columns;
}

function ogp_order_report($column, $order) {
    if ($column === 'ogp_order_report') {
        $order_id = $order->get_id();
        $customer_id = $order->get_customer_id();
        $nonce = wp_create_nonce('ogp_column_order_report');
        echo '<div class="ogp-report-container">';
        echo '<button type="button" class="button-primary ogp-get-order-report"
                style="background:#339966;color:#fff;border-color:#339966"
                data-order-id="'.esc_attr($order_id).'" 
                data-customer-id="'.esc_attr($customer_id).'"
                data-nonce="'.esc_attr($nonce).'">'. 
                esc_html(__('Check Report', 'order-growth-plugin')).'</button>';
        echo '</div>';
    }
}

function ogp_order_block($column, $order) {
    if ($column === 'ogp_order_block') {
        if (is_user_logged_in()) {
            $current_user = wp_get_current_user();
        }
        
        $order_id = $order->get_id();
        $order_ip = $order->get_customer_ip_address();
        $billing_phone = $order->get_billing_phone();
        $nonce = wp_create_nonce('ogp_blocking');
        $ip_exists = ogp_block_ip_search($order_ip);
        $label_ip = ($ip_exists == 1) ? 'Unblock IP' : 'Block IP';
        $number_exists = ogp_block_number_search($billing_phone);
        $label_number = ($number_exists == 1) ? 'Unblock Number' : 'Block Number';
        
        echo '<div>';
        echo '<p>'.esc_attr($order_ip).'</p>';
        echo '<button type="button" class="button-primary ogp-get-order-ip-block"
                style="background:#339966;color:#fff;border-color:#339966"
                data-current-user="'.esc_attr($current_user->user_login).'"
                data-block-type="IP" data-order-ip="'.esc_attr($order_ip).'"
                data-order-id="'.esc_attr($order_id).'" data-nonce="'.esc_attr($nonce).'">'.esc_attr($label_ip).'</button>';
        echo '</div>';
        
        echo '<div style="margin-top: 5px;">';
        echo '<p>'.esc_attr($billing_phone).'</p>';
        echo '<button type="button" class="button-primary ogp-get-order-number-block"
                style="background:#339966;color:#fff;border-color:#339966"
                data-current-user="'.esc_attr($current_user->user_login).'"
                data-block-type="Number" data-order-number="'.esc_js($billing_phone).'" 
                data-order-id="'.esc_attr($order_id).'" data-nonce="'.esc_attr($nonce).'">'.esc_attr($label_number).'</button>';
        echo '</div>';
    }   
}   

add_action('wp_ajax_ogp_fetch_column_order_report', 'ogp_fetch_column_order_report');
add_action('wp_ajax_nopriv_ogp_fetch_column_order_report', 'ogp_fetch_column_order_report');
function ogp_fetch_column_order_report() {
    if (!isset($_POST['ogp_column_order_report_nonce']) || !wp_verify_nonce($_POST['ogp_column_order_report_nonce'], 'ogp_column_order_report')) {
        wp_send_json_error('Invalid nonce.');
        wp_die();
    }
    
    $order_id = isset($_POST['ogp_column_order_report_id']) ? absint($_POST['ogp_column_order_report_id']) : 0;
    
    if ($order_id) {
        $order = wc_get_order($order_id);
        if ($order) {
            $billing_phone = $order->get_billing_phone();
            if(!empty($billing_phone)) {
                $delivery_details = ogp_get_order_details($billing_phone);
                $delivery_details = json_decode($delivery_details, true);
                $delivery_details_isMultidimensional = ogp_isMultidimensionalArray($delivery_details);
                
                if ($delivery_details_isMultidimensional === false) {
                    $message = isset($delivery_details['message']) ? $delivery_details['message'] : 'No data available';

                    // ✅ Upstream 429 (rate-limit) হলে – প্রোফাইলের মতোই মেসেজ পাঠান
                    if (stripos($message, '429') !== false || stripos($message, 'limit') !== false || stripos($message, 'লিমিট') !== false) {
                        wp_send_json_success([
                            'error_code'    => 429,
                            'error_message' => $message,
                            'number'        => $billing_phone,
                        ]);
                        wp_die();
                    }

                    // ✅ লিমিট না থাকলে 0%-ডেটা কেস
                    wp_send_json_success([
                        'number'  => $billing_phone,
                        'total'   => 0,
                        'success' => 0,
                        'failed'  => 0,
                        'ratio'   => 0,
                        'message' => $message
                    ]);
                } else {
                    // ---------- এখান থেকে সবকিছু else-এর ভিতরেই থাকবে ----------
                    // Initialize totals
                    $successful_delivery_total = 0;
                    $total_delivery_total = 0;
                    $cancel_delivery_total = 0;

                    // Initialize courier data with defaults
                    $successful_delivery_pathao = 0;
                    $total_delivery_pathao = 0;
                    $cancel_delivery_pathao = 0;
                    $success_ratio_pathao = 0;

                    $successful_delivery_steadfast = 0;
                    $total_delivery_steadfast = 0;
                    $cancel_delivery_steadfast = 0;
                    $success_ratio_steadfast = 0;

                    $successful_delivery_redx = 0;
                    $total_delivery_redx = 0;
                    $cancel_delivery_redx = 0;
                    $success_ratio_redx = 0;

                    $successful_delivery_paperfly = 0;
                    $total_delivery_paperfly = 0;
                    $cancel_delivery_paperfly = 0;
                    $success_ratio_paperfly = 0;

                    $pathaoData    = ogp_extractCourierData($delivery_details, 'pathao');
                    $steadfastData = ogp_extractCourierData($delivery_details, 'steadfast');
                    $redxData      = ogp_extractCourierData($delivery_details, 'redx');
                    $paperflyData  = ogp_extractCourierData($delivery_details, 'paperfly');

                    if ($pathaoData) {
                        $successful_delivery_pathao = isset($pathaoData['successful_delivery_pathao']) ? intval($pathaoData['successful_delivery_pathao']) : 0;
                        $total_delivery_pathao      = isset($pathaoData['total_delivery_pathao']) ? intval($pathaoData['total_delivery_pathao']) : 0;
                        $cancel_delivery_pathao     = $total_delivery_pathao - $successful_delivery_pathao;
                        $success_ratio_pathao       = ($total_delivery_pathao > 0) ? round(($successful_delivery_pathao/$total_delivery_pathao)*100) : 0;
                    }
                    if ($steadfastData) {
                        $successful_delivery_steadfast = isset($steadfastData['successful_delivery_steadfast']) ? intval($steadfastData['successful_delivery_steadfast']) : 0;
                        $cancel_delivery_steadfast     = isset($steadfastData['cancel_delivery_steadfast']) ? intval($steadfastData['cancel_delivery_steadfast']) : 0;
                        $total_delivery_steadfast      = $successful_delivery_steadfast + $cancel_delivery_steadfast;
                        $success_ratio_steadfast       = ($total_delivery_steadfast > 0) ? round(($successful_delivery_steadfast/$total_delivery_steadfast)*100) : 0;
                    }
                    if ($redxData) {
                        $successful_delivery_redx = isset($redxData['successful_delivery_redx']) ? intval($redxData['successful_delivery_redx']) : 0;
                        $total_delivery_redx      = isset($redxData['total_delivery_redx']) ? intval($redxData['total_delivery_redx']) : 0;
                        $cancel_delivery_redx     = $total_delivery_redx - $successful_delivery_redx;
                        $success_ratio_redx       = ($total_delivery_redx > 0) ? round(($successful_delivery_redx/$total_delivery_redx)*100) : 0;
                    }
                    if ($paperflyData){
                        $successful_delivery_paperfly = isset($paperflyData['successful_delivery_paperfly']) ? intval($paperflyData['successful_delivery_paperfly']) : 0;
                        $cancel_delivery_paperfly     = isset($paperflyData['cancel_delivery_paperfly']) ? intval($paperflyData['cancel_delivery_paperfly']) : 0;
                        $total_delivery_paperfly      = $successful_delivery_paperfly + $cancel_delivery_paperfly;
                        $success_ratio_paperfly       = ($total_delivery_paperfly > 0) ? round(($successful_delivery_paperfly/$total_delivery_paperfly)*100) : 0;
                    }

                    $successful_delivery_total = $successful_delivery_pathao + $successful_delivery_steadfast + $successful_delivery_redx + $successful_delivery_paperfly;
                    $cancel_delivery_total     = $cancel_delivery_pathao + $cancel_delivery_steadfast + $cancel_delivery_redx + $cancel_delivery_paperfly;
                    $total_delivery_total      = $total_delivery_pathao + $total_delivery_steadfast + $total_delivery_redx + $total_delivery_paperfly;
                    $success_ratio_total       = ($total_delivery_total > 0) ? round(($successful_delivery_total/$total_delivery_total)*100) : 0;

                    wp_send_json_success([
                        'number'  => $billing_phone,
                        'total'   => $total_delivery_total,
                        'success' => $successful_delivery_total,
                        'failed'  => $cancel_delivery_total,
                        'ratio'   => $success_ratio_total
                    ]);
                } // <-- এখানে else ব্লক শেষ

            } else {
                wp_send_json_error('Billing Phone not found.');
            }
        } else {
            wp_send_json_error('Order not found.');
        }
    } else {
        wp_send_json_error('Invalid order ID.');
    }
    
    wp_die();
}

add_action('admin_footer', 'ogp_add_order_report_modal');
function ogp_add_order_report_modal() {
    $screen = get_current_screen();
    if ($screen && ($screen->id === 'edit-shop_order' || $screen->id === 'woocommerce_page_wc-orders')) {
        ?>
        <div id="ogp-order-report-modal" class="ogp-modal" role="dialog" aria-modal="true" aria-labelledby="ogp-modal-title">
            <div class="ogp-modal-content ogp-order-report-modal-content">
                <div class="ogp-modal-header">
                    <h2 id="ogp-modal-title" class="ogp-modal-title">
                        <a href="#" id="ogp-customer-link" class="ogp-customer-link">OGP Order Report</a>
                    </h2>
                    <span class="ogp-close" aria-label="Close modal">&times;</span>
                </div>
                <div class="ogp-modal-body">
                    <button type="button" class="ogp-check-report-btn">Check Report</button>
                    
                    <div class="ogp-report-data" id="ogp-report-data" style="display: none;">
                        <div class="ogp-data-rows">
                            <div class="ogp-data-row">
                                <span class="ogp-label">Number:</span>
                                <span class="ogp-value" id="ogp-number"></span>
                            </div>
                            <div class="ogp-data-row">
                                <span class="ogp-label">Total:</span>
                                <span class="ogp-value" id="ogp-total"></span>
                            </div>
                            <div class="ogp-data-row">
                                <span class="ogp-label">Success:</span>
                                <span class="ogp-value" id="ogp-success"></span>
                            </div>
                            <div class="ogp-data-row">
                                <span class="ogp-label">Failed:</span>
                                <span class="ogp-value" id="ogp-failed"></span>
                            </div>
                            <div class="ogp-data-row">
                                <span class="ogp-label">Ratio:</span>
                                <span class="ogp-value" id="ogp-ratio"></span>
                            </div>
                        </div>
                        
                        <div class="ogp-legend">
                            <div class="ogp-legend-item">
                                <span class="ogp-swatch" style="background-color: #00A32A;"></span>
                                <span class="ogp-legend-text">80–100%</span>
                            </div>
                            <div class="ogp-legend-item">
                                <span class="ogp-swatch" style="background-color: #DBA617;"></span>
                                <span class="ogp-legend-text">60–80%</span>
                            </div>
                            <div class="ogp-legend-item">
                                <span class="ogp-swatch" style="background-color: #F97316;"></span>
                                <span class="ogp-legend-text">40–60%</span>
                            </div>
                            <div class="ogp-legend-item">
                                <span class="ogp-swatch" style="background-color: #D63638;"></span>
                                <span class="ogp-legend-text">0–40%</span>
                            </div>
                        </div>
                        
                        <div class="ogp-status-comment">
                            <h3 class="ogp-status-title">Status & Comment</h3>
                            <div class="ogp-data-row">
                                <span class="ogp-label">Status:</span>
                                <span class="ogp-value" id="ogp-status"></span>
                            </div>
                            <div class="ogp-comments">
                                <p id="ogp-comment-en"></p>
                                <p id="ogp-comment-bn"></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
?>
