<?php
function ogp_order_settings_page_callback(){
	if (!current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'order-growth-plugin'));
    }
	
	if (isset($_POST['ogp_order_interval']) && check_admin_referer('ogp_order_settings', 'ogp_order_settings_nonce')) {
		update_option('ogp_order_interval_validation', intval($_POST['ogp_order_interval_validation']));
		update_option('ogp_order_interval', intval($_POST['ogp_order_interval']));
        update_option('ogp_order_interval_message', sanitize_text_field($_POST['ogp_order_interval_message']));
        update_option('ogp_block_message', sanitize_text_field($_POST['ogp_block_message']));
		update_option('ogp_phone_validation', intval($_POST['ogp_phone_validation']));
		update_option('ogp_phone_validation_message', sanitize_text_field($_POST['ogp_phone_validation_message']));
		update_option('ogp_report_in_order_list', intval($_POST['ogp_report_in_order_list']));
		update_option('ogp_block_in_order_list', intval($_POST['ogp_block_in_order_list']));
		
        echo '<div class="updated"><p>Settings saved successfully.</p></div>';
	}
	$ogp_order_interval_validation = get_option('ogp_order_interval_validation', 1);
$ogp_order_interval = get_option('ogp_order_interval', 10);

// ⏳ অপেক্ষার বার্তা ( %d মিনিট প্লেসহোল্ডার ঠিক রাখুন )
$ogp_order_interval_message = get_option(
    'ogp_order_interval_message',
    '⏳ পরবর্তী অর্ডারের জন্য আপনাকে %d মিনিট অপেক্ষা করতে হবে!'
);

// 🔒 ব্লক বার্তা
$ogp_block_message = get_option(
    'ogp_block_message',
    '🔒 আপনাকে কোনো কারণে আমাদের সিস্টেম থেকে ব্লক করা হয়েছে। 📞 অনুগ্রহ করে আমাদের সাথে যোগাযোগ করুন।'
);

$ogp_phone_validation = get_option('ogp_phone_validation', 1);

// 📱 ফোন ভ্যালিডেশন বার্তা
$ogp_phone_validation_message = get_option(
    'ogp_phone_validation_message',
    '📱 অনুগ্রহ করে নিচে আপনার ১১ সংখ্যার সঠিক মোবাইল নাম্বারটি প্রদান করুন! 🔢 যেমন: 01XXXXXXXXX'
);

$ogp_report_in_order_list = get_option('ogp_report_in_order_list', 0);
$ogp_block_in_order_list  = get_option('ogp_block_in_order_list', 0);

?>
	<div class="wrap" id="ogp_order_settings">
		<div class="ogp-container">
			<form method="post" action="">
			<?php wp_nonce_field('ogp_order_settings', 'ogp_order_settings_nonce');?>
		
			
			<!-- Moved Show Report In Order List to the very top -->
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Show Courier Report in Order Column</h2>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<div id="ogp_report_in_order_list_toggle" style="width: fit-content;"></div>
					<input class="ogp-input-box" type="hidden" id="ogp_report_in_order_list" name="ogp_report_in_order_list" value="<?php echo esc_attr($ogp_report_in_order_list);?>">
				</div>
			</div>
			
			<!-- Moved Show Block In Order List to second position -->
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Show Block Switch in Order Column</h2>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<div id="ogp_block_in_order_list_toggle" style="width: fit-content;"></div>
					<input class="ogp-input-box" type="hidden" id="ogp_block_in_order_list" name="ogp_block_in_order_list" value="<?php echo esc_attr($ogp_block_in_order_list);?>">
				</div>
			</div>
			
			<!-- Moved Block Message to third position -->
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Block Message</h2>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<label for="ogp_block_message" class="ogp-settings-label">Message displayed if ordering is blocked for the user.</label>
					<input class="ogp-input-box" type="text" id="ogp_block_message" name="ogp_block_message" value="<?php echo esc_attr($ogp_block_message);?>"
					placeholder="Your account is currently blocked from placing orders. Please contact support.">
				</div>
			</div>
			
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Phone Number Verification</h2>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<div id="ogp_phone_validation_toggle" style="width: fit-content;"></div>
					<input class="ogp-input-box" type="hidden" id="ogp_phone_validation" name="ogp_phone_validation" value="<?php echo esc_attr($ogp_phone_validation);?>">
				</div>
			</div>
			
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Phone Number Verification Notice</h2>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<label for="ogp_phone_validation_message" class="ogp-settings-label">Text shown when the phone number format is invalid.</label>
					<input class="ogp-input-box" type="text" id="ogp_phone_validation_message" name="ogp_phone_validation_message" value="<?php echo esc_attr($ogp_phone_validation_message);?>"
					placeholder="অনুগ্রহ করে আপনার ১১ সংখ্যার সঠিক মোবাইল নাম্বারটি প্রদান করুন">
				</div>
			</div>
			
			<!-- Minimum Order Gap section down -->
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Minimum Order Gap</h2>
				<div style="display: flex; flex-direction: column; margin-bottom: 0.5rem;">
					<div id="ogp_order_interval_toggle" style="width: fit-content;"></div>
					<input class="ogp-input-box" type="hidden" id="ogp_order_interval_validation" name="ogp_order_interval_validation" value="<?php echo esc_attr($ogp_order_interval_validation);?>">
				</div>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<label for="ogp_order_interval" class="ogp-settings-label">Set the minimum gap between orders (minutes)</label>
					<input class="ogp-input-box" type="number" id="ogp_order_interval" name="ogp_order_interval" min="0" value="<?php echo  esc_attr($ogp_order_interval);?>">
				</div>
			</div>
			
			<!-- Moved Order Interval Message to follow Order Interval -->
			<div class="ogp-settings-section" style="margin-top: 1.5rem;">
				<h2>Order Gap Warning</h2>
				<div style="display: flex; flex-direction: column; gap: 0.5rem;">
					<label for="ogp_order_interval_message" class="ogp-settings-label">Shown when a new order is placed before the cooldown ends. Use %d for remaining minutes.</label>
					<input class="ogp-input-box" type="text" id="ogp_order_interval_message" name="ogp_order_interval_message" value="<?php echo esc_attr($ogp_order_interval_message);?>"
					placeholder="Please wait %d minutes before placing your next order. You can place another order in %d minutes">
				</div>
			</div>
			
			<div class="ogp-settings-footer">
				<div class="ogp-save-button-container ogp-save-button-container-right">
					<input type="submit" class="button-primary" value="Save Changes">
				</div>
			</div>
			</form>
		</div>
		
	</div>
<?php
}
?>
