<?php
/**
 * Plugin Name: Order Growth Plugin
 * Description: Order Growth Plugin protects your WooCommerce shop from fake or risky orders by blocking suspicious customers.It also saves incomplete checkouts, so you can follow up and recover lost sales easily.
 *
 * Version: 2.0
 * Requires PHP: 7.4
 * Requires at least: 5.2   // WordPress version
 * Tested up to: 6.5
 * Author: Inventrix IT
 * Text Domain: order-growth-plugin
 */

if (!defined('ABSPATH')) exit;

define('OGP_FILE', __FILE__);
define('OGP_DIR', plugin_dir_path(__FILE__));
define('OGP_URL', plugin_dir_url(__FILE__));
define('OGP_VER', '1.0.0');

// ---------------------------------------------
// Include IC and FOS modules (menus disabled)
// ---------------------------------------------
require_once OGP_DIR . 'modules/ogp_IC/ogp_ic.php';
require_once OGP_DIR . 'modules/order-growth-plugin/order-growth-plugin.php';
require_once OGP_DIR . 'modules/order-growth-plugin/ogp-settings-page.php';
require_once OGP_DIR . 'modules/order-growth-plugin/ogp-blocking-page.php';
require_once OGP_DIR . 'modules/ogp_IC/includes/ogp_ic_analytics.php';
require_once OGP_DIR . 'modules/ogp_IC/includes/ogp_ic_setting.php';
require_once OGP_DIR . 'modules/ogp_IC/includes/ogp_ic_license.php';
require_once OGP_DIR . 'modules/ogp_IC/includes/ogp_ic_admin.php';
require_once OGP_DIR . 'modules/ogp_IC/includes/ogp_ic_analytics_graph.php';

// Ensure we have the global IC license handler
global $ogp_ic_license_handler;
if (!isset($ogp_ic_license_handler) || !is_object($ogp_ic_license_handler)) {
    $ogp_ic_license_handler = new OGP_IC_License_Handler();
}

function ogp_license_valid() {
    global $ogp_ic_license_handler;
    if (is_object($ogp_ic_license_handler) && method_exists($ogp_ic_license_handler, 'is_license_valid')) {
        return $ogp_ic_license_handler->is_license_valid();
    }
    return false;
}

/* ============================================================
 * Unified Admin Headings (helper + CSS)
 * ============================================================ */

// আমাদের প্লাগিনের অ্যাডমিন পেজ কিনা চেক (স্লাগ অনুযায়ী)
if ( ! function_exists('ogp_is_plugin_admin_page') ) {
    function ogp_is_plugin_admin_page() {
        $allowed = array(
            'ogp-dashboard',
            'ogp-incomplete-checkout',
            'ogp-block-list',
            'ogp-analytics',
            'ogp-settings',
            'ogp-license',
        );
        $page = isset($_GET['page']) ? sanitize_key($_GET['page']) : '';
        return in_array($page, $allowed, true);
    }
}

// কমন হেডার রেন্ডারার (যেখানে দরকার সেখানেই ব্যবহার)
if ( ! function_exists('ogp_render_page_header') ) {
    function ogp_render_page_header( $title ) {
        echo '<div class="wrap"><h1 class="wp-heading-inline">' . esc_html($title) . '</h1></div>';
    }
}

// ইউনিফাইড CSS: সব টার্গেট পেজে wrap>h1 স্ট্যান্ডার্ডাইজ
add_action('admin_head', function () {
    if ( ! ogp_is_plugin_admin_page() ) return;

    echo '<style id="ogp-unified-headings">
    #wpbody-content .wrap > h1:first-child,
    #wpbody-content .wrap > h1.wp-heading-inline:first-of-type{
        font-size:28px;
        font-weight:700;
        line-height:1.25;
        letter-spacing:0.2px;
        margin:18px 0 12px 0; /* উপরে/নিচে স্পেস */
        color:#1d2327;
    }
    #wpbody-content .wrap{padding-top:0;}
    #wpbody-content .wrap > .page-title-action{margin-left:8px;}
    </style>';
});

/* ============================================================
 * Activation: redirect to License + ensure FOS table
 * ============================================================ */
register_activation_hook(OGP_FILE, function(){
    add_option('ogp_do_activation_redirect', 1);
    if (function_exists('ogp_activation_hook')) {
        ogp_activation_hook();
    }
});

add_action('admin_init', function () {
    if (get_option('ogp_do_activation_redirect')) {
        delete_option('ogp_do_activation_redirect');
        if (!isset($_GET['activate-multi'])) {
            wp_safe_redirect(admin_url('admin.php?page=ogp-license'));
            exit;
        }
    }
});
/* ============================================================
 * License: free the seat on plugin deactivation (MINIMAL PATCH)
 * ============================================================ */
register_deactivation_hook(OGP_FILE, function () {
    // IC লাইসেন্স অপশন থেকে লাইসেন্স কী/ইনস্ট্যান্স নিন
    $lic = get_option('ogp_ic_license');
    if (is_array($lic) && !empty($lic['key'])) {
        $api  = 'https://order-growth-plugin-license.inventrix-it.com/license-activations.php?action=deactivate';
        $body = array(
            'license_key'  => $lic['key'],
            'instance'     => isset($lic['instance']) ? $lic['instance'] : '',
            'product_slug' => 'incomplete-checkouts',
            'site_url'     => home_url('/'),
        );
        // সার্ভারে ডিঅ্যাক্টিভেট হিট: সিট ফ্রি হবে
        wp_remote_post($api, array('timeout' => 10, 'body' => $body));
    }
});

/* ============================================================
 * Admin Menus (final IA)
 * ============================================================ */
add_action('admin_menu', function () {

    add_menu_page(
        __('Order Growth Plugin','order-growth-plugin'),
        __('Order Growth Plugin','order-growth-plugin'),
        'manage_options',
        'ogp-dashboard',
        'ogp_render_dashboard_page',
        'dashicons-chart-line',
        26
    );

    add_submenu_page(
        'ogp-dashboard',
        __('Order Growth Plugin','order-growth-plugin'),
        __('Order Growth Plugin','order-growth-plugin'),
        'manage_options',
        'ogp-dashboard',
        'ogp_render_dashboard_page'
    );

    add_submenu_page(
        'ogp-dashboard',
        __('Incomplete Checkout','order-growth-plugin'),
        __('Incomplete Checkout','order-growth-plugin'),
        'manage_options',
        'ogp-incomplete-checkout',
        'ogp_render_ic_main_page'
    );

    add_submenu_page(
        'ogp-dashboard',
        __('Block List','order-growth-plugin'),
        __('Block List','order-growth-plugin'),
        'manage_options',
        'ogp-block-list',
        'ogp_render_block_list_page'
    );

    add_submenu_page(
        'ogp-dashboard',
        __('Analytics','order-growth-plugin'),
        __('Analytics','order-growth-plugin'),
        'manage_options',
        'ogp-analytics',
        'ogp_render_analytics_summary_page'
    );

    add_submenu_page(
        'ogp-dashboard',
        __('Settings','order-growth-plugin'),
        __('Settings','order-growth-plugin'),
        'manage_options',
        'ogp-settings',
        'ogp_render_merged_settings_page'
    );

    // License: সরাসরি module callback ব্যবহার — যাতে ডাবল H1 না হয়
    add_submenu_page(
        'ogp-dashboard',
        __('License','order-growth-plugin'),
        __('License','order-growth-plugin'),
        'manage_options',
        'ogp-license',
        'ogp_ic_license_page_callback'
    );
}, 20);

// Hide original menus if they accidentally appear

// Keep original menus visible unless explicitly hidden.
add_action('admin_menu', function(){
    // Always hide our legacy self menu if present
    remove_menu_page('order-growth-plugin-settings');
    // Do NOT hide Incomplete Checkouts by default.
    if (defined('OGP_HIDE_IC_MENU') && OGP_HIDE_IC_MENU) {
        remove_menu_page('incomplete-checkouts');
    }
}, 999);


/* ============================================================
 * Inline license gate wrapper
 * ============================================================ */
function ogp_require_license_then($callback) {
    if (ogp_license_valid()) {
        call_user_func($callback);
    } else {
        if (function_exists('ogp_ic_license_page_callback')) {
            if (function_exists('ogp_ic_license_page_callback')) {
                ogp_ic_license_page_callback();
            } else {
                global $ogp_ic_license_handler;
                if (is_object($ogp_ic_license_handler)) { $ogp_ic_license_handler->license_page(); }
            }
        } else {
            echo '<div class="wrap"><h1>License</h1><p>License module missing.</p></div>';
        }
    }
}

/* ============================================================
 * Pages
 * ============================================================ */

// Dashboard — আমাদের নিজস্ব হেডিং থাকবে (module এখানে H1 দেয় না)
function __ogp_orig__ogp_render_dashboard_page() {
    if (!ogp_license_valid()) { wp_safe_redirect(admin_url('admin.php?page=ogp-license')); exit; }

    echo '<div class="wrap ogp-overview">';
    echo '<h1 class="wp-heading-inline">' . esc_html__('Order Growth Plugin','order-growth-plugin') . '</h1>';

    // Hero
    echo '<div class="ogp-hero" style="margin:18px 0 22px;padding:20px;border:1px solid #e5e7eb;border-radius:18px;background:linear-gradient(180deg,#f7fafc,#ffffff);box-shadow:0 8px 20px rgba(0,0,0,.05);">';
    echo '<p style="margin:0 0 10px;color:#334155;font-size:clamp(20px,2.4vw,28px);font-weight:800;line-height:1.35;">' . esc_html__('Grow sales by up to 30% with smarter recovery + risk control.','order-growth-plugin') . '</p>';
    echo '<p style="margin:0 0 10px;color:#334155;font-size:clamp(20px,2.4vw,28px);font-weight:800;line-height:1.35;">' . esc_html__('স্মার্ট রিকভারি আর রিস্ক কন্ট্রোলে সেল প্রায় ৩০% পর্যন্ত বাড়তে পারে।','order-growth-plugin') . '</p>';
    echo '<div class="ogp-cta" style="margin-top:14px;display:flex;gap:10px;flex-wrap:wrap;">';
    echo '<a class="ogp-btn ogp-btn--outline" href="' . esc_url('https://www.inventrix-it.com/') . '" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:8px;background:#ffffff;color:#0f172a;padding:9px 14px;border-radius:10px;text-decoration:none;font-weight:700;box-shadow:0 2px 0 rgba(0,0,0,.04);border:1px solid #e5e7eb;">🌐 ' . esc_html__('Website','order-growth-plugin') . '</a>';
    echo '<a class="ogp-btn ogp-btn--outline" href="' . esc_url('https://www.facebook.com/InventrixIT/') . '" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:8px;background:#ffffff;color:#0f172a;padding:9px 14px;border-radius:10px;text-decoration:none;font-weight:700;box-shadow:0 2px 0 rgba(0,0,0,.04);border:1px solid #e5e7eb;">📘 ' . esc_html__('Facebook','order-growth-plugin') . '</a>';
    echo '<a class="ogp-btn ogp-btn--wa" href="' . esc_url('https://wa.me/8801875838782') . '" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:8px;background:#25D366;color:#ffffff;padding:9px 14px;border-radius:10px;text-decoration:none;font-weight:700;box-shadow:0 2px 0 rgba(0,0,0,.04);">💬 ' . esc_html__('WhatsApp','order-growth-plugin') . '</a>';
    echo '</div></div>';

    // Grid
    echo '<div class="ogp-grid" style="display:grid;grid-template-columns:repeat(2,minmax(0,1fr));gap:16px;">';

    // Incomplete Checkout
    echo '<div class="ogp-card" style="border:1px solid #e5e7eb;border-radius:16px;background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.05);padding:16px;position:relative;overflow:hidden;">';
    echo '<h3 style="margin:0 0 8px;font-weight:800;font-size:18px;color:#0f172a;"><span class="emoji" style="margin-right:6px;">🧺</span>' . esc_html__('Incomplete Checkout','order-growth-plugin') . '</h3>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('Turn lost checkouts into real orders with quick follow-ups & smart reminders.','order-growth-plugin') . '</p>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('অসম্পূর্ণ চেকআউটকে বাস্তব অর্ডারে রূপ দিন—দ্রুত ফলো-আপ ও স্মার্ট রিমাইন্ডারে।','order-growth-plugin') . '</p>';
    echo '<span class="tag" style="display:inline-block;margin-top:8px;background:#f1f5f9;border:1px solid #e2e8f0;color:#0f172a;font-size:13px;border-radius:999px;padding:4px 8px;font-weight:700;">' . esc_html__('Recovery Booster','order-growth-plugin') . '</span><br/>';
    echo '<a class="ogp-go" href="' . esc_url(admin_url('admin.php?page=ogp-incomplete-checkout')) . '" style="margin-top:10px;display:inline-flex;align-items:center;gap:6px;font-weight:800;color:#2271B1;text-decoration:none;">' . esc_html__('Go','order-growth-plugin') . ' →</a>';
    echo '</div>';

    // Block List
    echo '<div class="ogp-card" style="border:1px solid #e5e7eb;border-radius:16px;background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.05);padding:16px;position:relative;overflow:hidden;">';
    echo '<h3 style="margin:0 0 8px;font-weight:800;font-size:18px;color:#0f172a;"><span class="emoji" style="margin-right:6px;">🛡️</span>' . esc_html__('Block List','order-growth-plugin') . '</h3>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('Stop repeat fraud & risky customers—cut failed deliveries and cash loss.','order-growth-plugin') . '</p>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('বারবার ফ্রড/রিস্কি কাস্টমার থামান—রিটার্ন ও ক্ষতি কমান।','order-growth-plugin') . '</p>';
    echo '<span class="tag" style="display:inline-block;margin-top:8px;background:#f1f5f9;border:1px solid #e2e8f0;color:#0f172a;font-size:13px;border-radius:999px;padding:4px 8px;font-weight:700;">' . esc_html__('Risk Control','order-growth-plugin') . '</span><br/>';
    echo '<a class="ogp-go" href="' . esc_url(admin_url('admin.php?page=ogp-block-list')) . '" style="margin-top:10px;display:inline-flex;align-items:center;gap:6px;font-weight:800;color:#2271B1;text-decoration:none;">' . esc_html__('Go','order-growth-plugin') . ' →</a>';
    echo '</div>';

    // Analytics
    echo '<div class="ogp-card" style="border:1px solid #e5e7eb;border-radius:16px;background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.05);padding:16px;position:relative;overflow:hidden;">';
    echo '<h3 style="margin:0 0 8px;font-weight:800;font-size:18px;color:#0f172a;"><span class="emoji" style="margin-right:6px;">📊</span>' . esc_html__('Analytics','order-growth-plugin') . '</h3>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('See wins, blocks & recovery rate at a glance—decide with confidence.','order-growth-plugin') . '</p>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('উইন, ব্লক, রিকভারি রেট এক নজরে—নির্ভয়ে সিদ্ধান্ত নিন।','order-growth-plugin') . '</p>';
    echo '<span class="tag" style="display:inline-block;margin-top:8px;background:#f1f5f9;border:1px solid #e2e8f0;color:#0f172a;font-size:13px;border-radius:999px;padding:4px 8px;font-weight:700;">' . esc_html__('1-Row Summary','order-growth-plugin') . '</span><br/>';
    echo '<a class="ogp-go" href="' . esc_url(admin_url('admin.php?page=ogp-analytics')) . '" style="margin-top:10px;display:inline-flex;align-items:center;gap:6px;font-weight:800;color:#2271B1;text-decoration:none;">' . esc_html__('Go','order-growth-plugin') . ' →</a>';
    echo '</div>';

    // Setting
    echo '<div class="ogp-card" style="border:1px solid #e5e7eb;border-radius:16px;background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.05);padding:16px;position:relative;overflow:hidden;">';
    echo '<h3 style="margin:0 0 8px;font-weight:800;font-size:18px;color:#0f172a;"><span class="emoji" style="margin-right:6px;">⚙️</span>' . esc_html__('Setting','order-growth-plugin') . '</h3>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('All controls on one page—tune rules fast, then save with one click.','order-growth-plugin') . '</p>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('সব কন্ট্রোল এক পেজে—দ্রুত রুল সেট করে এক ক্লিকে সেভ করুন।','order-growth-plugin') . '</p>';
    echo '<span class="tag" style="display:inline-block;margin-top:8px;background:#f1f5f9;border:1px solid #e2e8f0;color:#0f172a;font-size:13px;border-radius:999px;padding:4px 8px;font-weight:700;">' . esc_html__('One-Page Control','order-growth-plugin') . '</span><br/>';
    echo '<a class="ogp-go" href="' . esc_url(admin_url('admin.php?page=ogp-settings')) . '" style="margin-top:10px;display:inline-flex;align-items:center;gap:6px;font-weight:800;color:#2271B1;text-decoration:none;">' . esc_html__('Go','order-growth-plugin') . ' →</a>';
    echo '</div>';

    // License
    echo '<div class="ogp-card" style="border:1px solid #e5e7eb;border-radius:16px;background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.05);padding:16px;position:relative;overflow:hidden;">';
    echo '<h3 style="margin:0 0 8px;font-weight:800;font-size:18px;color:#0f172a;"><span class="emoji" style="margin-right:6px;">🔑</span>' . esc_html__('License','order-growth-plugin') . '</h3>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('Activate to unlock updates & features—no hassle.','order-growth-plugin') . '</p>';
    echo '<p style="margin:3px 0;color:#374151;font-size:15px;line-height:1.5;font-weight:700;">' . esc_html__('অ্যাক্টিভ করুন—ঝামেলা ছাড়া আপডেট ও ফিচার উপভোগ করুন।','order-growth-plugin') . '</p>';
    echo '<span class="tag" style="display:inline-block;margin-top:8px;background:#f1f5f9;border:1px solid #e2e8f0;color:#0f172a;font-size:13px;border-radius:999px;padding:4px 8px;font-weight:700;">' . esc_html__('Keep It Updated','order-growth-plugin') . '</span><br/>';
    echo '<a class="ogp-go" href="' . esc_url(admin_url('admin.php?page=ogp-license')) . '" style="margin-top:10px;display:inline-flex;align-items:center;gap:6px;font-weight:800;color:#2271B1;text-decoration:none;">' . esc_html__('Go','order-growth-plugin') . ' →</a>';
    echo '</div>';

    echo '</div>'; // grid

    // Company / Contact section
    echo '<div class="ogp-company" style="margin-top:22px;border:1px solid #e5e7eb;border-radius:18px;padding:16px;background:#fff;display:flex;flex-direction:column;gap:10px;">';
    echo '<h3 style="margin:0 0 6px;font-size:18px;font-weight:800;">' . esc_html__('Inventrix IT','order-growth-plugin') . '</h3>';
    echo '<div class="ogp-links" style="display:flex;flex-wrap:wrap;gap:10px;">';
    echo '<a class="ogp-chip ogp-chip--site" href="' . esc_url('https://www.inventrix-it.com/') . '" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:8px;border:1px solid #bbf7d0;background:#ecfdf5;border-radius:999px;padding:8px 12px;font-weight:800;color:#065f46;text-decoration:none;">🌐 ' . esc_html__('Website','order-growth-plugin') . '</a>';
    echo '<a class="ogp-chip ogp-chip--fb" href="' . esc_url('https://www.facebook.com/InventrixIT/') . '" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:8px;border:1px solid #dbeafe;background:#EBF2FF;border-radius:999px;padding:8px 12px;font-weight:800;color:#1d4ed8;text-decoration:none;">📘 ' . esc_html__('Facebook','order-growth-plugin') . '</a>';
    echo '<a class="ogp-chip ogp-chip--wa" href="' . esc_url('https://wa.me/8801875838782') . '" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:8px;border:1px solid #bef264;background:#ecfccb;border-radius:999px;padding:8px 12px;font-weight:800;color:#166534;text-decoration:none;">💬 ' . esc_html__('WhatsApp','order-growth-plugin') . '</a>';
    echo '</div>';
    echo '</div>'; // company

    echo '</div>'; // .wrap close
}

// Incomplete Checkouts — ডাবল এড়াতে আমাদের H1 সরানো হয়েছে
function __ogp_orig__ogp_render_ic_main_page() {
    if (!ogp_license_valid() && isset($_GET['page']) && $_GET['page']!=='ogp-license') { wp_safe_redirect(admin_url('admin.php?page=ogp-license')); exit; }

    if (!function_exists('ogp_ic_render_abandoned_admin_page')) {
        echo '<div class="error"><p>IC page not available.</p></div>';
        return;
    }
    ogp_ic_render_abandoned_admin_page(); // module নিজেই H1 দেয়; CSS দিয়ে একরকম দেখাবে
}

// Block List — ডাবল এড়াতে আমাদের H1 সরানো হয়েছে
function __ogp_orig__ogp_render_block_list_page() {
    if (!ogp_license_valid() && isset($_GET['page']) && $_GET['page']!=='ogp-license') { wp_safe_redirect(admin_url('admin.php?page=ogp-license')); exit; }

    if (!function_exists('ogp_blocking_page_callback')) {
        echo '<div class="error"><p>OGP Block List page not available.</p></div>';
        return;
    }
    ogp_blocking_page_callback(); // module নিজেই H1 দেয়; CSS unify করবে
}

// Analytics — আমাদের নিজের H1 (এখানে module H1 নেই)
function __ogp_orig__ogp_render_analytics_summary_page() {
    if (!ogp_license_valid() && isset($_GET['page']) && $_GET['page']!=='ogp-license') { wp_safe_redirect(admin_url('admin.php?page=ogp-license')); exit; }

    echo '<div class="wrap">';
    echo '<h1 class="wp-heading-inline">' . esc_html__('Analytics','order-growth-plugin') . '</h1>';

    if (!function_exists('ogp_ic_analytics_cards_data')) {
        echo '<div class="error"><p>Analytics module missing.</p></div></div>';
        return;
    }

    $cards = ogp_ic_analytics_cards_data();

    echo '<div style="display:grid;grid-template-columns:repeat(4,minmax(200px,1fr));gap:16px;">';

    ogp_ic_render_card('Last 24 Hours', $cards['24h']);
    ogp_ic_render_card('Last 7 Days',  $cards['7d']);
    ogp_ic_render_card('Last 30 Days', $cards['30d']);
    ogp_ic_render_card('All Time',     $cards['all']);

// === Doughnut Charts: Header row + 4 charts (inline grid, borderless) ===
echo '<div style="margin-top:16px;">';

// Titles row (bold + position relative; left:0px)
echo '<div style="display:grid;grid-template-columns:repeat(4,minmax(240px,1fr));gap:16px;margin:12px 0 8px;align-items:end;">'
   . '<div style="position:relative; left:0px; text-align:center; font-weight:700;">Last 24 Hours</div>'
   . '<div style="position:relative; left:48px; text-align:center; font-weight:700;">Last 7 Days</div>'
   . '<div style="position:relative; left:92px; text-align:center; font-weight:700;">Last 30 Days</div>'
   . '<div style="position:relative; left:136px; text-align:center; font-weight:700;">All Time</div>'
   . '</div>';
// Charts row
echo '<div style="display:grid;grid-template-columns:repeat(4,minmax(240px,1fr));gap:0;">';

echo '<div data-ogp-block style="position:relative; left:0px;   width:100%; padding:0;background:transparent;border:none;box-shadow:none;"><div class="inside" style="padding:0;"><div style="position:relative;height:320px;"><canvas id="ogp-donut-24h" data-ogp-dataset="last24"></canvas><div class="ogp-no-data" style="display:none;text-align:center;padding:80px 0;opacity:.7;">No data to display</div></div></div></div>';

echo '<div data-ogp-block style="position:relative; left:62px;  width:100%; padding:0;background:transparent;border:none;box-shadow:none;"><div class="inside" style="padding:0;"><div style="position:relative;height:320px;"><canvas id="ogp-donut-7d" data-ogp-dataset="last7"></canvas><div class="ogp-no-data" style="display:none;text-align:center;padding:80px 0;opacity:.7;">No data to display</div></div></div></div>';

echo '<div data-ogp-block style="position:relative; left:124px;  width:100%; padding:0;background:transparent;border:none;box-shadow:none;"><div class="inside" style="padding:0;"><div style="position:relative;height:320px;"><canvas id="ogp-donut-30d" data-ogp-dataset="last30"></canvas><div class="ogp-no-data" style="display:none;text-align:center;padding:80px 0;opacity:.7;">No data to display</div></div></div></div>';

echo '<div data-ogp-block style="position:relative; left:186px;  width:100%; padding:0;background:transparent;border:none;box-shadow:none;"><div class="inside" style="padding:0;"><div style="position:relative;height:320px;"><canvas id="ogp-donut-all" data-ogp-dataset="all"></canvas><div class="ogp-no-data" style="display:none;text-align:center;padding:80px 0;opacity:.7;">No data to display</div></div></div></div>';
echo '</div>'; // charts grid
echo '</div>'; // wrapper
echo '</div></div>';
}

// Helper to capture inner HTML of a form from a callback output
function ogp_capture_inner_form($callback){
    ob_start();
    call_user_func($callback);
    $out = ob_get_clean();

    // Extract the first <form ...>...</form>
    if (preg_match('~<form[^>]*>(.*)</form>~isU', $out, $m)) {
        $formInner = $m[1];
        // Remove common save button containers
        $formInner = preg_replace('~<p class="submit">.*?</p>~is', '', $formInner);
        $formInner = preg_replace('~<div class="ogp-save-button-container.*?</div>~is', '', $formInner);
        return $formInner;
    }
    // Fallback: return whole output if form not found
    return $out;
}

// Merged settings page — আমাদের নিজস্ব H1 (এখানে module H1 নেই)
function __ogp_orig__ogp_render_merged_settings_page() {
    if (!ogp_license_valid() && isset($_GET['page']) && $_GET['page']!=='ogp-license') { wp_safe_redirect(admin_url('admin.php?page=ogp-license')); exit; }

    // When submitted, run underlying savers silently then show a single notice
    if (isset($_POST['ogp_save_settings'])) {
        if (function_exists('ogp_order_settings_page_callback')) {
            ob_start(); ogp_order_settings_page_callback(); ob_end_clean();
        }
        if (function_exists('ogp_ic_render_settings_page')) {
            ob_start(); ogp_ic_render_settings_page(); ob_end_clean();
        }
        echo '<div class="updated"><p>' . esc_html__('Settings saved successfully.','order-growth-plugin') . '</p></div>';
    }

    echo '<div class="wrap">';
    echo '<h1 class="wp-heading-inline">' . esc_html__('Settings','order-growth-plugin') . '</h1>';

    echo '<form method="post" action="">';
    wp_nonce_field('ogp_order_settings', 'ogp_order_settings_nonce');
    echo '<input type="hidden" name="save_settings" value="1">'; // so IC saver triggers
    echo '<input type="hidden" name="ogp_save_settings" value="1">'; // our flag

    // Section 1: FOS Order Settings
    if (function_exists('ogp_order_settings_page_callback')) {
        echo ogp_capture_inner_form('ogp_order_settings_page_callback');
    } else {
        echo '<p>OGP Order Settings not available.</p>';
    }
echo '<h2 style="margin-top:-40px; font-size:23px; margin-bottom:10px;">' . esc_html__('Incomplete Checkout','order-growth-plugin') . '</h2>';

    if (function_exists('ogp_ic_render_settings_page')) {
        echo ogp_capture_inner_form('ogp_ic_render_settings_page');
    } else {
        echo '<p>IC Settings not available.</p>';
    }

    echo '<p class="submit"><button type="submit" class="button button-primary">' . esc_html__('Save Changes','order-growth-plugin') . '</button></p>';
    echo '</form></div>';
}

/* ============================================================
 * Public wrappers (license gate respected)
 * ============================================================ */
function ogp_render_dashboard_page() {
    ogp_require_license_then('__ogp_orig__ogp_render_dashboard_page');
}
function ogp_render_ic_main_page() {
    ogp_require_license_then('__ogp_orig__ogp_render_ic_main_page');
}
function ogp_render_block_list_page() {
    ogp_require_license_then('__ogp_orig__ogp_render_block_list_page');
}
function ogp_render_analytics_summary_page() {
    ogp_require_license_then('__ogp_orig__ogp_render_analytics_summary_page');
}
function ogp_render_merged_settings_page() {
    ogp_require_license_then('__ogp_orig__ogp_render_merged_settings_page');
}


// === OGP Analytics: enqueue Chart.js and chart script on Analytics page only ===
add_action('admin_enqueue_scripts', function($hook){
    if (!isset($_GET['page']) || $_GET['page'] !== 'ogp-analytics') { return; }

    // Chart.js v4 (CDN)
    wp_enqueue_script(
        'chartjs',
        'https://cdn.jsdelivr.net/npm/chart.js@4.4.4/dist/chart.umd.min.js',
        array(),
        '4.4.4',
        true
    );

    // Our multi-chart script
    wp_enqueue_script(
        'ogp-analytics-chart',
        plugins_url('assets/js/ogp-analytics-chart.js', __FILE__),
        array('chartjs'),
        '1.0.0',
        true
    );

    $cards = function_exists('ogp_ic_analytics_cards_data') ? ogp_ic_analytics_cards_data() : array();
    $stats = array(
        'last24' => array(
            'completed'    => isset($cards['24h']['completed']) ? intval($cards['24h']['completed']) : 0,
            'cancelled'    => isset($cards['24h']['cancelled']) ? intval($cards['24h']['cancelled']) : 0,
            'auto_cleanup' => isset($cards['24h']['auto_cleanup']) ? intval($cards['24h']['auto_cleanup']) : 0,
            'pending'      => isset($cards['24h']['pending']) ? intval($cards['24h']['pending']) : 0,
            'total'        => isset($cards['24h']['total']) ? intval($cards['24h']['total']) : 0,
        ),
        'last7' => array(
            'completed'    => isset($cards['7d']['completed']) ? intval($cards['7d']['completed']) : 0,
            'cancelled'    => isset($cards['7d']['cancelled']) ? intval($cards['7d']['cancelled']) : 0,
            'auto_cleanup' => isset($cards['7d']['auto_cleanup']) ? intval($cards['7d']['auto_cleanup']) : 0,
            'pending'      => isset($cards['7d']['pending']) ? intval($cards['7d']['pending']) : 0,
            'total'        => isset($cards['7d']['total']) ? intval($cards['7d']['total']) : 0,
        ),
        'last30' => array(
            'completed'    => isset($cards['30d']['completed']) ? intval($cards['30d']['completed']) : 0,
            'cancelled'    => isset($cards['30d']['cancelled']) ? intval($cards['30d']['cancelled']) : 0,
            'auto_cleanup' => isset($cards['30d']['auto_cleanup']) ? intval($cards['30d']['auto_cleanup']) : 0,
            'pending'      => isset($cards['30d']['pending']) ? intval($cards['30d']['pending']) : 0,
            'total'        => isset($cards['30d']['total']) ? intval($cards['30d']['total']) : 0,
        ),
        'all' => array(
            'completed'    => isset($cards['all']['completed']) ? intval($cards['all']['completed']) : 0,
            'cancelled'    => isset($cards['all']['cancelled']) ? intval($cards['all']['cancelled']) : 0,
            'auto_cleanup' => isset($cards['all']['auto_cleanup']) ? intval($cards['all']['auto_cleanup']) : 0,
            'pending'      => isset($cards['all']['pending']) ? intval($cards['all']['pending']) : 0,
            'total'        => isset($cards['all']['total']) ? intval($cards['all']['total']) : 0,
        ),
        'labels' => array('Completed','Cancelled','Auto Cleanup','Pending'),
    );
    wp_localize_script('ogp-analytics-chart', 'OGP_ANALYTICS_DATA', $stats);
});
