<?php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Options cleanup (keep this)
// ---------------------------
$options_to_delete = array(
    'ogp_ic_abandoned_cleanup_interval',
    'ogp_ic_last_cleanup_time',
    'ogp_ic_cleanup_schedule_updated',
    'ogp_do_activation_redirect',
    'ogp_order_interval',
    'ogp_order_interval_message',
    'ogp_order_interval_validation',
    'ogp_phone_validation',
    'ogp_phone_validation_message',
    'ogp_block_message',
    // Add any other plugin options here
);

foreach ($options_to_delete as $option) {
    delete_option($option);
}

// Transients cleanup
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_ogp_%'");
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_ogp_%'");

// ---------------------------
// Cron cleanup (keep this)
// ---------------------------
wp_clear_scheduled_hook('ogp_ic_cleanup_old_abandoned_leads_event');
wp_clear_scheduled_hook('ogp_cleanup_incomplete_checkouts');

// ---------------------------
// (Optional) Custom post type cleanup (keep if you want posts removed)
// ---------------------------
$posts = get_posts(array(
    'post_type'   => 'abandoned_lead',
    'numberposts' => -1,
    'post_status' => 'any',
));
foreach ($posts as $post) {
    wp_delete_post($post->ID, true);
}
